/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

class IncompleteCondition
extends BaseCondition
implements FilterConditionBeginContext {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)IncompleteCondition.class.getName());
    private boolean isNegated = false;
    private BaseCondition filterCondition;

    IncompleteCondition(QueryFactory queryFactory) {
        super(queryFactory);
    }

    @Override
    void setQueryBuilder(QueryBuilder queryBuilder) {
        super.setQueryBuilder(queryBuilder);
        if (this.filterCondition != null) {
            this.filterCondition.setQueryBuilder(queryBuilder);
        }
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        if (this.filterCondition == null) {
            throw log.incompleteCondition();
        }
        return this.filterCondition.accept(visitor);
    }

    @Override
    public FilterConditionEndContext having(Expression expression) {
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("having(..)");
        }
        AttributeCondition attributeCondition = new AttributeCondition(this.queryFactory, expression);
        attributeCondition.setNegated(this.isNegated);
        attributeCondition.setQueryBuilder(this.queryBuilder);
        attributeCondition.setParent(this);
        this.filterCondition = attributeCondition;
        return attributeCondition;
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        return this.having(Expression.property(attributePath));
    }

    @Override
    public BaseCondition not() {
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("not()");
        }
        this.isNegated = !this.isNegated;
        return this;
    }

    @Override
    public BaseCondition not(FilterConditionContext fcc) {
        if (fcc == null) {
            throw log.argumentCannotBeNull();
        }
        if (this.filterCondition != null) {
            throw log.cannotUseOperatorAgain("not(..)");
        }
        BaseCondition baseCondition = ((BaseCondition)fcc).getRoot();
        if (baseCondition.queryFactory != this.queryFactory) {
            throw log.conditionWasCreatedByAnotherFactory();
        }
        if (baseCondition.queryBuilder != null) {
            throw log.conditionIsAlreadyInUseByAnotherBuilder();
        }
        boolean bl = this.isNegated = !this.isNegated;
        if (this.isNegated) {
            NotCondition notCondition = new NotCondition(this.queryFactory, baseCondition);
            notCondition.setQueryBuilder(this.queryBuilder);
            this.filterCondition = notCondition;
        } else {
            baseCondition.setQueryBuilder(this.queryBuilder);
            this.filterCondition = baseCondition;
        }
        return this.filterCondition;
    }
}

