/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.impl.BaseLuceneLock;
import org.infinispan.lucene.impl.CommonLockObtainUtils;
import org.infinispan.lucene.impl.DirectoryLucene;

public class BaseLockFactory
extends LockFactory {
    public static final BaseLockFactory INSTANCE = new BaseLockFactory();

    public BaseLuceneLock obtainLock(Directory dir, String lockName) throws IOException {
        if (!(dir instanceof DirectoryLucene)) {
            throw new UnsupportedOperationException("BaseLuceneLock can only be used with DirectoryLucene, got: " + dir);
        }
        DirectoryLucene infinispanDirectory = (DirectoryLucene)dir;
        int affinitySegmentId = infinispanDirectory.getAffinitySegmentId();
        Cache<Object, Integer> distLockCache = infinispanDirectory.getDistLockCache();
        String indexName = infinispanDirectory.getIndexName();
        BaseLuceneLock lock = new BaseLuceneLock(distLockCache, indexName, lockName, affinitySegmentId);
        CommonLockObtainUtils.attemptObtain(lock);
        return lock;
    }
}

