/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.MergeOnStore;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.group.Group;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class AtomicKeySetImpl<K>
implements MergeOnStore {
    private static final Type[] TYPES = Type.values();
    private static Log log = LogFactory.getLog(FineGrainedAtomicMap.class);
    private final ByteString cacheName;
    private final Object group;
    private final transient Collection<K> added;
    private final transient Collection<K> removed;
    private final transient Set<K> keys;

    static <K> AtomicKeySetImpl<K> create(String cacheName, Object group, Set<K> keys) {
        return new AtomicKeySetImpl<K>(ByteString.fromString(cacheName), group, keys, null, null);
    }

    private AtomicKeySetImpl(ByteString cacheName, Object group, Set<K> keys, Collection<K> added, Collection<K> removed) {
        this.cacheName = cacheName;
        this.group = group;
        this.keys = keys;
        this.added = added;
        this.removed = removed;
    }

    @Override
    public Object merge(Object other) {
        Set<K> actual = null;
        if (other != null) {
            if (other.getClass() != AtomicKeySetImpl.class) {
                throw log.atomicMapHasWrongType(other, AtomicKeySetImpl.class);
            }
            actual = ((AtomicKeySetImpl)other).keys;
        }
        HashSet<K> keys = new HashSet<K>((actual == null ? 0 : actual.size()) + (this.added == null ? 0 : this.added.size()) + (this.removed == null ? 0 : this.removed.size()));
        if (actual != null) {
            keys.addAll(actual);
        }
        if (this.added != null) {
            keys.addAll(this.added);
        }
        if (this.removed != null) {
            keys.addAll(this.removed);
        }
        return new AtomicKeySetImpl(this.cacheName, this.group, keys, null, null);
    }

    private Set<K> toSet() {
        if (this.removed == null && this.added == null) {
            return this.keys;
        }
        HashSet<K> set = new HashSet<K>();
        set.addAll(this.keys);
        if (this.removed != null) {
            set.removeAll(this.removed);
        }
        if (this.added != null) {
            set.addAll(this.added);
        }
        return set;
    }

    public String toString() {
        return "AtomicKeySetImpl{keys=" + this.keys + ", added=" + this.added + ", removed=" + this.removed + "}";
    }

    public static class FunctionExternalizer
    implements AdvancedExternalizer<Externalizable> {
        public Set<Class<? extends Externalizable>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Key.class, ReadAll.class, Touch.class, Add.class, AddAll.class, Remove.class, RemoveAll.class, RemoveMap.class});
        }

        public Integer getId() {
            return 121;
        }

        public void writeObject(ObjectOutput output, Externalizable object) throws IOException {
            output.writeByte(object.type().ordinal());
            object.writeTo(output);
        }

        public Externalizable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Type type = TYPES[input.readByte()];
            switch (type) {
                case KEY: {
                    return Key.readFrom(input);
                }
                case READ_ALL: {
                    return ReadAll.instance();
                }
                case TOUCH: {
                    return Touch.readFrom(input);
                }
                case ADD: {
                    return Add.readFrom(input);
                }
                case ADD_ALL: {
                    return AddAll.readFrom(input);
                }
                case REMOVE: {
                    return Remove.readFrom(input);
                }
                case REMOVE_ALL: {
                    return RemoveAll.instance();
                }
                case REMOVE_MAP: {
                    return RemoveMap.instance();
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<AtomicKeySetImpl> {
        private final GlobalComponentRegistry gcr;

        public Externalizer(GlobalComponentRegistry gcr) {
            this.gcr = gcr;
        }

        public Set<Class<? extends AtomicKeySetImpl>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AtomicKeySetImpl.class});
        }

        public Integer getId() {
            return 120;
        }

        public void writeObject(ObjectOutput output, AtomicKeySetImpl object) throws IOException {
            ByteString.writeObject(output, object.cacheName);
            output.writeObject(object.group);
        }

        public AtomicKeySetImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ByteString cacheName1 = ByteString.readObject(input);
            Object group = input.readObject();
            ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName1);
            InvocationContextFactory icf = cr.getComponent(InvocationContextFactory.class);
            InvocationContext ctx = icf.createInvocationContext(false, -1);
            AsyncInterceptorChain chain = cr.getComponent(AsyncInterceptorChain.class);
            GetKeysInGroupCommand cmd = cr.getCommandsFactory().buildGetKeysInGroupCommand(0L, group);
            Map map = (Map)chain.invoke(ctx, cmd);
            CacheEntry entry = ctx.lookupEntry(group);
            if (entry != null) {
                entry.setSkipLookup(false);
            }
            if (ctx.isInTxScope()) {
                ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getVersionsRead().remove(group);
            }
            return new AtomicKeySetImpl(cacheName1, group, map.keySet(), null, null);
        }
    }

    static class RemoveMap<K>
    implements Function<EntryView.ReadWriteEntryView<Object, Object>, Set<K>>,
    Externalizable {
        private static final RemoveMap INSTANCE = new RemoveMap();

        RemoveMap() {
        }

        public static <K> RemoveMap<K> instance() {
            return INSTANCE;
        }

        @Override
        public Set<K> apply(EntryView.ReadWriteEntryView<Object, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                view.remove();
                if (value instanceof AtomicKeySetImpl) {
                    AtomicKeySetImpl set = (AtomicKeySetImpl)value;
                    return set.toSet();
                }
            }
            return null;
        }

        @Override
        public Type type() {
            return Type.REMOVE_MAP;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
        }
    }

    static class RemoveAll<K>
    implements Function<EntryView.ReadWriteEntryView<Object, Object>, Set<K>>,
    Externalizable {
        private static final RemoveAll INSTANCE = new RemoveAll();

        RemoveAll() {
        }

        public static <K> RemoveAll<K> instance() {
            return INSTANCE;
        }

        @Override
        public Set<K> apply(EntryView.ReadWriteEntryView<Object, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                if (value instanceof AtomicKeySetImpl) {
                    AtomicKeySetImpl set = (AtomicKeySetImpl)value;
                    HashSet currentlyRemoved = new HashSet();
                    currentlyRemoved.addAll(set.keys);
                    if (set.added != null) {
                        currentlyRemoved.addAll(set.added);
                    }
                    HashSet removed = new HashSet(currentlyRemoved);
                    if (set.removed != null) {
                        removed.addAll(set.removed);
                    }
                    view.set(new AtomicKeySetImpl(set.cacheName, set.group, Collections.emptySet(), null, removed), new MetaParam.Writable[0]);
                    return currentlyRemoved;
                }
                throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
            }
            throw log.atomicMapDoesNotExist();
        }

        @Override
        public Type type() {
            return Type.REMOVE_ALL;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
        }
    }

    static class Remove<K>
    implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
    Externalizable {
        private final K key;

        public Remove(K key) {
            this.key = key;
        }

        public static <K> Remove readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Remove<Object>(input.readObject());
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                if (value instanceof AtomicKeySetImpl) {
                    AtomicKeySetImpl set = (AtomicKeySetImpl)value;
                    if (set.added != null && set.added.contains(this.key)) {
                        Collection added = set.added.stream().filter(k -> !this.key.equals(k)).collect(Collectors.toList());
                        view.set(new AtomicKeySetImpl(set.cacheName, view.key(), set.keys, added, set.removed), new MetaParam.Writable[0]);
                    } else {
                        Collection<Object> removed;
                        if (set.removed == null) {
                            removed = Collections.singleton(this.key);
                        } else {
                            if (set.removed.contains(this.key)) {
                                return null;
                            }
                            removed = new ArrayList(set.removed.size() + 1);
                            removed.addAll(set.removed);
                            removed.add(this.key);
                        }
                        view.set(new AtomicKeySetImpl(set.cacheName, view.key(), set.keys, set.added, removed), new MetaParam.Writable[0]);
                    }
                    return null;
                }
                throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
            }
            throw log.atomicMapDoesNotExist();
        }

        @Override
        public Type type() {
            return Type.REMOVE;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
        }
    }

    static class AddAll<K>
    implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
    Externalizable {
        private final Collection<? extends K> keys;

        public AddAll(Collection<? extends K> keys) {
            this.keys = keys;
        }

        public static <K> AddAll readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            ArrayList keys = (ArrayList)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            return new AddAll<K>(keys);
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                if (value instanceof AtomicKeySetImpl) {
                    AtomicKeySetImpl set = (AtomicKeySetImpl)value;
                    Collection removed = set.removed;
                    ArrayList<K> added = set.added;
                    for (Object key : this.keys) {
                        if (removed != null && removed.contains(key)) {
                            if (removed == set.removed) {
                                removed = removed.stream().filter(k -> !key.equals(k)).collect(Collectors.toCollection(ArrayList::new));
                                continue;
                            }
                            removed.remove(key);
                            continue;
                        }
                        if (added == null) {
                            added = new ArrayList<K>(this.keys.size());
                        } else if (added == set.added) {
                            added = new ArrayList(set.added.size() + this.keys.size());
                        }
                        added.add(key);
                    }
                    view.set(new AtomicKeySetImpl(set.cacheName, set.group, set.keys, added, removed), new MetaParam.Writable[0]);
                    return null;
                }
                throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
            }
            throw log.atomicMapDoesNotExist();
        }

        @Override
        public Type type() {
            return Type.ADD_ALL;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        }
    }

    static class Add<K>
    implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
    Externalizable {
        private final K key;

        public Add(K key) {
            this.key = key;
        }

        public static <K> Add readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Add<Object>(input.readObject());
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                if (value instanceof AtomicKeySetImpl) {
                    AtomicKeySetImpl set = (AtomicKeySetImpl)value;
                    if (set.removed != null && set.removed.contains(this.key)) {
                        Collection removed = set.removed.stream().filter(k -> !this.key.equals(k)).collect(Collectors.toList());
                        view.set(new AtomicKeySetImpl(set.cacheName, set.group, set.keys, set.added, removed), new MetaParam.Writable[0]);
                    } else {
                        Collection<Object> added;
                        if (set.added == null) {
                            added = Collections.singleton(this.key);
                        } else {
                            if (set.added.contains(this.key)) {
                                return null;
                            }
                            added = new ArrayList(set.added.size() + 1);
                            added.addAll(set.added);
                            added.add(this.key);
                        }
                        view.set(new AtomicKeySetImpl(set.cacheName, set.group, set.keys, added, set.removed), new MetaParam.Writable[0]);
                    }
                    return null;
                }
                throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
            }
            throw log.atomicMapDoesNotExist();
        }

        @Override
        public Type type() {
            return Type.ADD;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            output.writeObject(this.key);
        }
    }

    static class Touch<MK>
    implements Function<EntryView.ReadWriteEntryView<MK, Object>, Void>,
    Externalizable {
        private final ByteString cacheName;

        public Touch(ByteString cacheName) {
            this.cacheName = cacheName;
        }

        public static <MK> Touch readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            ByteString cacheName = ByteString.readObject(input);
            return new Touch<MK>(cacheName);
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<MK, Object> view) {
            if (view.find().isPresent()) {
                Object value = view.find().get();
                if (!(value instanceof AtomicKeySetImpl)) {
                    throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
                }
            } else {
                view.set(new AtomicKeySetImpl(this.cacheName, view.key(), Collections.emptySet(), null, null), new MetaParam.Writable[0]);
            }
            return null;
        }

        @Override
        public Type type() {
            return Type.TOUCH;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            ByteString.writeObject(output, this.cacheName);
        }
    }

    static class ReadAll<K>
    implements Function<EntryView.ReadEntryView<Object, Object>, Set<K>>,
    Externalizable {
        private static final ReadAll INSTANCE = new ReadAll();

        ReadAll() {
        }

        static <K> ReadAll<K> instance() {
            return INSTANCE;
        }

        @Override
        public Set<K> apply(EntryView.ReadEntryView<Object, Object> view) {
            return view.find().map(value -> {
                if (value instanceof AtomicKeySetImpl) {
                    return ((AtomicKeySetImpl)value).toSet();
                }
                throw log.atomicMapHasWrongType(value, AtomicKeySetImpl.class);
            }).orElse(null);
        }

        @Override
        public Type type() {
            return Type.READ_ALL;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
        }
    }

    static final class Key<MK, K>
    implements Externalizable {
        private final MK group;
        private final K key;

        Key(MK group, K key) {
            this.group = group;
            this.key = key;
        }

        public static <MK, K> Key<MK, K> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
            return new Key<Object, Object>(input.readObject(), input.readObject());
        }

        @Group
        public MK group() {
            return this.group;
        }

        public K key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            if (!this.group.equals(key1.group)) {
                return false;
            }
            return this.key.equals(key1.key);
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        @Override
        public Type type() {
            return Type.KEY;
        }

        @Override
        public void writeTo(ObjectOutput output) throws IOException {
            output.writeObject(this.group);
            output.writeObject(this.key);
        }

        public String toString() {
            return "AtomicKeySetImpl.Key{group=" + this.group + ", key=" + this.key + "}";
        }
    }

    static interface Externalizable {
        public Type type();

        public void writeTo(ObjectOutput var1) throws IOException;
    }

    private static enum Type {
        KEY,
        READ_ALL,
        TOUCH,
        ADD,
        ADD_ALL,
        REMOVE,
        REMOVE_ALL,
        REMOVE_MAP;

    }
}

