/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.util.function.RemovableFunction;

public class EncoderEntryMapper<K, V>
implements RemovableFunction<CacheEntry<K, V>, CacheEntry<K, V>> {
    private transient InternalEntryFactory entryFactory;
    private final Class<? extends Encoder> keyEncoderClass;
    private final Class<? extends Encoder> valueEncoderClass;
    private final Class<? extends Wrapper> keyWrapperClass;
    private final Class<? extends Wrapper> valueWrapperClass;
    private transient Encoder keyEncoder;
    private transient Encoder valueEncoder;
    private transient Wrapper keyWrapper;
    private transient Wrapper valueWrapper;

    public EncoderEntryMapper(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        this.keyEncoderClass = keyEncoderClass;
        this.valueEncoderClass = valueEncoderClass;
        this.keyWrapperClass = keyWrapperClass;
        this.valueWrapperClass = valueWrapperClass;
    }

    @Inject
    public void injectDependencies(EncoderRegistry encoderRegistry, InternalEntryFactory factory) {
        this.entryFactory = factory;
        this.keyEncoder = encoderRegistry.getEncoder(this.keyEncoderClass);
        this.valueEncoder = encoderRegistry.getEncoder(this.valueEncoderClass);
        this.keyWrapper = encoderRegistry.getWrapper(this.keyWrapperClass);
        this.valueWrapper = encoderRegistry.getWrapper(this.valueWrapperClass);
    }

    @Override
    public CacheEntry<K, V> apply(CacheEntry<K, V> e) {
        Object newValue;
        boolean keyFilterable = this.keyEncoder.isStorageFormatFilterable();
        boolean valueFilterable = this.valueEncoder.isStorageFormatFilterable();
        K key = e.getKey();
        Object unwrapped = this.keyWrapper.unwrap(key);
        Object newKey = keyFilterable ? unwrapped : this.keyEncoder.fromStorage(unwrapped);
        V value = e.getValue();
        Object unwrappedValue = this.valueWrapper.unwrap(value);
        Object object = newValue = valueFilterable ? unwrappedValue : this.valueEncoder.fromStorage(unwrappedValue);
        if (key != newKey || value != newValue) {
            return this.entryFactory.create(newKey, newValue, e.getMetadata().version(), e.getCreated(), e.getLifespan(), e.getLastUsed(), e.getMaxIdle());
        }
        return e;
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderEntryMapper> {
        public Set<Class<? extends EncoderEntryMapper>> getTypeClasses() {
            return Collections.singleton(EncoderEntryMapper.class);
        }

        public Integer getId() {
            return 124;
        }

        public void writeObject(ObjectOutput output, EncoderEntryMapper object) throws IOException {
            output.writeObject(object.keyEncoderClass);
            output.writeObject(object.valueEncoderClass);
            output.writeObject(object.keyWrapperClass);
            output.writeObject(object.valueWrapperClass);
        }

        public EncoderEntryMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderEntryMapper((Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject(), (Class)input.readObject());
        }
    }
}

