/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyManyCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 56;
    private Collection<? extends K> keys;
    private Consumer<EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyCommand(Collection<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f, Params params, CommandInvocationId commandInvocationId) {
        super(commandInvocationId, params);
        this.keys = keys;
        this.f = f;
    }

    public WriteOnlyManyCommand(WriteOnlyManyCommand<K, V> command) {
        super(command);
        this.keys = command.keys;
        this.f = command.f;
    }

    public WriteOnlyManyCommand() {
    }

    public void setKeys(Collection<? extends K> keys) {
        this.keys = keys;
    }

    public final WriteOnlyManyCommand<K, V> withKeys(Collection<? extends K> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 56;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keys = MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, ArrayList::new);
        this.f = (Consumer)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (K k : this.keys) {
            CacheEntry cacheEntry = ctx.lookupEntry(k);
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            this.f.accept(EntryViews.writeOnly(cacheEntry));
        }
        return null;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOnlyManyCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append('}');
        return sb.toString();
    }

    public Collection<Object> getKeysToLock() {
        return this.keys;
    }

    @Override
    public Mutation<K, V, ?> toMutation(K key) {
        return new Mutations.Write(this.f);
    }
}

