/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyManyEntriesCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 57;
    private Map<? extends K, ? extends V> entries;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyEntriesCommand(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f, Params params, CommandInvocationId commandInvocationId) {
        super(commandInvocationId, params);
        this.entries = entries;
        this.f = f;
    }

    public WriteOnlyManyEntriesCommand(WriteOnlyManyEntriesCommand<K, V> command) {
        super(command);
        this.entries = command.entries;
        this.f = command.f;
    }

    public WriteOnlyManyEntriesCommand() {
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    public final WriteOnlyManyEntriesCommand<K, V> withEntries(Map<? extends K, ? extends V> entries) {
        this.setEntries(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 57;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.entries);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.entries = (Map)input.readObject();
        this.f = (BiConsumer)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Map.Entry<K, V> entry : this.entries.entrySet()) {
            CacheEntry cacheEntry = ctx.lookupEntry(entry.getKey());
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            this.f.accept(entry.getValue(), EntryViews.writeOnly(cacheEntry));
        }
        return null;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.entries.keySet();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyEntriesCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOnlyManyEntriesCommand{");
        sb.append("entries=").append(this.entries);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append('}');
        return sb.toString();
    }

    public Collection<Object> getKeysToLock() {
        return this.entries.keySet();
    }

    @Override
    public Mutation<K, V, ?> toMutation(K key) {
        return new Mutations.WriteWithValue(this.entries.get(key), this.f);
    }
}

