/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DeltaAwareCacheEntry<K>
implements CacheEntry<K, DeltaAware>,
MVCCEntry<K, DeltaAware> {
    private static final Log log = LogFactory.getLog(DeltaAwareCacheEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    private InvocationContext ctx;
    private PersistenceManager persistenceManager;
    private TimeService timeService;
    protected K key;
    protected CacheEntry<K, DeltaAware> wrappedEntry;
    protected DeltaAware value;
    protected DeltaAware initialValue;
    protected final List<Delta> deltas;
    protected byte flags = 0;

    public DeltaAwareCacheEntry(K key, DeltaAware value, CacheEntry<K, DeltaAware> wrappedEntry, InvocationContext ctx, PersistenceManager persistenceManager, TimeService timeService) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.initialValue = value;
        this.wrappedEntry = wrappedEntry;
        this.ctx = ctx;
        this.persistenceManager = persistenceManager;
        this.timeService = timeService;
        this.deltas = new LinkedList<Delta>();
    }

    public void appendDelta(Delta d) {
        this.deltas.add(d);
        this.setChanged(true);
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return -1L;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public boolean skipLookup() {
        return this.isFlagSet(Flags.SKIP_LOOKUP);
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final DeltaAware getValue() {
        return this.value;
    }

    @Override
    public final DeltaAware setValue(DeltaAware value) {
        DeltaAware oldValue = this.getValue();
        this.value = value;
        DeltaAware newValueCopy = value;
        this.deltas.clear();
        this.deltas.add(d -> newValueCopy);
        return oldValue;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public final void commit(DataContainer<K, DeltaAware> container) {
        PersistenceUtil.loadAndComputeInDataContainer(container, this.persistenceManager, this.key, this.ctx, this.timeService, (key, oldEntry, factory) -> {
            DeltaAware containerValue;
            InternalCacheEntry<Object, DeltaAware> newEntry = oldEntry;
            DeltaAware deltaAware = containerValue = oldEntry == null ? null : (DeltaAware)oldEntry.getValue();
            if (containerValue != null && containerValue != this.value) {
                this.value = containerValue;
            }
            if (!this.deltas.isEmpty()) {
                if (this.isCreated()) {
                    this.value = null;
                    for (Delta delta : this.deltas) {
                        this.value = delta.merge(this.value);
                    }
                    this.value.commit();
                    newEntry = factory.create(key, this.value, this.extractMetadata(null));
                } else if (this.value != null) {
                    boolean makeCopy = this.value instanceof CopyableDeltaAware;
                    if (makeCopy) {
                        this.value = ((CopyableDeltaAware)this.value).copy();
                    }
                    for (Delta delta : this.deltas) {
                        this.value = delta.merge(this.value);
                    }
                    if (makeCopy) {
                        newEntry = oldEntry == null ? factory.create(key, this.value, this.extractMetadata(null)) : factory.update(oldEntry, this.value, this.extractMetadata(oldEntry));
                    }
                    this.value.commit();
                }
            }
            return newEntry;
        });
    }

    private Metadata extractMetadata(CacheEntry<K, DeltaAware> entry) {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.getMetadata();
        }
        return entry == null ? null : entry.getMetadata();
    }

    @Override
    public void resetCurrentValue() {
        this.deltas.clear();
        this.flags = 0;
        this.setValid(true);
    }

    @Override
    public void updatePreviousValue() {
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    @Override
    public final void setChanged(boolean changed) {
        this.setFlag(changed, Flags.CHANGED);
    }

    @Override
    public void setExpired(boolean expired) {
        this.setFlag(expired, Flags.EXPIRED);
    }

    @Override
    public boolean isExpired() {
        return this.isFlagSet(Flags.EXPIRED);
    }

    @Override
    public boolean isValid() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isValid();
        }
        return this.isFlagSet(Flags.VALID);
    }

    @Override
    public final void setValid(boolean valid) {
        this.setFlag(valid, Flags.VALID);
    }

    @Override
    public final boolean isCreated() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isCreated();
        }
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        this.setFlag(created, Flags.CREATED);
    }

    @Override
    public boolean isRemoved() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isRemoved();
        }
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isEvicted();
        }
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public final void setRemoved(boolean removed) {
        this.setFlag(removed, Flags.REMOVED);
    }

    @Override
    public void setEvicted(boolean evicted) {
        this.setFlag(evicted, Flags.EVICTED);
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public void setLoaded(boolean loaded) {
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
        this.setFlag(skipLookup, Flags.SKIP_LOOKUP);
    }

    private void setFlag(boolean enable, Flags flag) {
        if (enable) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode((Object)this) + "){key=" + this.key + ", value=" + this.value + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + '}';
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(Metadata metadata) {
    }

    public DeltaAwareCacheEntry<K> clone() {
        try {
            return (DeltaAwareCacheEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8),
        EVICTED(16),
        SKIP_LOOKUP(64),
        EXPIRED(128);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

