/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.FunctionalEntryVersionAdapter;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;

@Experimental
public final class MetaParamsInternalMetadata
implements InternalMetadata,
MetaParam.Lookup {
    final MetaParams params;

    public static Metadata from(MetaParams params) {
        return new MetaParamsInternalMetadata(params);
    }

    private MetaParamsInternalMetadata(MetaParams params) {
        this.params = params;
    }

    @Override
    public long created() {
        return this.params.find(MetaParam.MetaCreated.class).map(mc -> mc.get()).orElse(0L);
    }

    @Override
    public long lastUsed() {
        return this.params.find(MetaParam.MetaLastUsed.class).map(ml -> ml.get()).orElse(0L);
    }

    @Override
    public boolean isExpired(long now) {
        long expiryTime = this.expiryTime();
        return expiryTime >= 0L && expiryTime <= now;
    }

    @Override
    public long expiryTime() {
        long maxIdle;
        long deadline = -1L;
        long lifespan = this.lifespan();
        if (lifespan >= 0L) {
            deadline = this.created() + lifespan;
        }
        if ((maxIdle = this.maxIdle()) >= 0L) {
            deadline = deadline < 0L ? this.lastUsed() + maxIdle : Math.min(deadline, this.lastUsed() + maxIdle);
        }
        return deadline;
    }

    @Override
    public long lifespan() {
        return this.params.find(MetaParam.MetaLifespan.class).orElse(MetaParam.MetaLifespan.defaultValue()).get();
    }

    @Override
    public long maxIdle() {
        return this.params.find(MetaParam.MetaMaxIdle.class).orElse(MetaParam.MetaMaxIdle.defaultValue()).get();
    }

    @Override
    public EntryVersion version() {
        return this.params.find(MetaParam.MetaEntryVersion.class).map(MetaParamsInternalMetadata::versionOrNull).orElse(null);
    }

    private static EntryVersion versionOrNull(MetaParam.MetaEntryVersion mev) {
        org.infinispan.commons.api.functional.EntryVersion entryVersion = mev.get();
        return entryVersion instanceof FunctionalEntryVersionAdapter ? ((FunctionalEntryVersionAdapter)entryVersion).get() : null;
    }

    @Override
    public Builder builder() {
        return new Builder(this.params.copy());
    }

    public <T> Optional<T> findMetaParam(Class<T> type) {
        return this.params.find(type);
    }

    public String toString() {
        return "MetaParamsInternalMetadata{params=" + this.params + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<MetaParamsInternalMetadata> {
        public void writeObject(ObjectOutput oo, MetaParamsInternalMetadata o) throws IOException {
            oo.writeObject(o.params);
        }

        public MetaParamsInternalMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            MetaParams params = (MetaParams)input.readObject();
            return new MetaParamsInternalMetadata(params);
        }

        public Set<Class<? extends MetaParamsInternalMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MetaParamsInternalMetadata.class});
        }

        public Integer getId() {
            return 89;
        }
    }

    public static class Builder
    implements Metadata.Builder {
        private final MetaParams params;

        public Builder(MetaParams params) {
            this.params = params;
        }

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.params.add((MetaParam.Writable)new MetaParam.MetaLifespan(unit.toMillis(time)));
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            this.params.add((MetaParam.Writable)new MetaParam.MetaLifespan(time));
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.params.add((MetaParam.Writable)new MetaParam.MetaMaxIdle(unit.toMillis(time)));
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            this.params.add((MetaParam.Writable)new MetaParam.MetaMaxIdle(time));
            return this;
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.params.add((MetaParam.Writable)new MetaParam.MetaEntryVersion((org.infinispan.commons.api.functional.EntryVersion)new FunctionalEntryVersionAdapter(version)));
            return this;
        }

        @Override
        public Metadata build() {
            return new MetaParamsInternalMetadata(this.params);
        }

        @Override
        public Metadata.Builder merge(Metadata metadata) {
            if (metadata instanceof MetaParamsInternalMetadata) {
                this.params.merge(((MetaParamsInternalMetadata)metadata).params);
            } else {
                if (!this.params.find(MetaParam.MetaLifespan.class).isPresent()) {
                    this.lifespan(metadata.lifespan());
                }
                if (!this.params.find(MetaParam.MetaMaxIdle.class).isPresent()) {
                    this.maxIdle(metadata.maxIdle());
                }
                if (!this.params.find(MetaParam.MetaEntryVersion.class).isPresent()) {
                    this.version(metadata.version());
                }
            }
            return this;
        }
    }
}

