/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.group.impl.GroupFilter;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;

public class GroupingInterceptor
extends DDAsyncInterceptor {
    private CacheNotifier<?, ?> cacheNotifier;
    private GroupManager groupManager;
    private InternalEntryFactory factory;
    private boolean isPassivationEnabled;
    private DistributionManager distributionManager;

    @Inject
    public void injectDependencies(CacheNotifier<?, ?> cacheNotifier, GroupManager groupManager, InternalEntryFactory factory, Configuration configuration, DistributionManager distributionManager) {
        this.cacheNotifier = cacheNotifier;
        this.groupManager = groupManager;
        this.factory = factory;
        this.isPassivationEnabled = configuration.persistence().passivation();
        this.distributionManager = distributionManager;
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        Object groupName = command.getGroupName();
        command.setGroupOwner(this.distributionManager.getCacheTopology().isWriteOwner(groupName));
        if (!command.isGroupOwner() || !this.isPassivationEnabled) {
            return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
                if (rv instanceof List) {
                    this.filter((List)rv);
                }
            });
        }
        KeyListener listener = new KeyListener(groupName, this.groupManager, this.factory);
        this.cacheNotifier.addListener(listener);
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            this.cacheNotifier.removeListener(listener);
            if (rv instanceof List) {
                ((List)rv).addAll(listener.activatedKeys);
                this.filter((List)rv);
            } else if (rv instanceof Map) {
                for (CacheEntry entry : listener.activatedKeys) {
                    ((Map)rv).put(entry.getKey(), entry.getValue());
                }
            }
        });
    }

    private void filter(List<CacheEntry> list) {
        for (int i = 0; i < list.size(); ++i) {
            CacheEntry entry = list.get(i);
            if (!(entry instanceof MVCCEntry)) continue;
            list.set(i, this.factory.create(entry));
        }
    }

    @Listener
    public static class KeyListener {
        private final ConcurrentLinkedQueue<CacheEntry> activatedKeys;
        private final GroupFilter<Object> filter;
        private final InternalEntryFactory factory;

        public KeyListener(Object groupName, GroupManager groupManager, InternalEntryFactory factory) {
            this.factory = factory;
            this.filter = new GroupFilter(groupName, groupManager);
            this.activatedKeys = new ConcurrentLinkedQueue();
        }

        @CacheEntryActivated
        public void handleRemove(CacheEntryActivatedEvent<?, ?> event) {
            Object key = event.getKey();
            if (this.filter.accept(key)) {
                this.activatedKeys.add(this.factory.create(key, event.getValue(), event.getMetadata()));
            }
        }
    }
}

