/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.ql;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.QueryRendererDelegate;
import org.infinispan.objectfilter.impl.ql.QueryResolverDelegate;
import org.infinispan.objectfilter.impl.ql.parse.IckleLexer;
import org.infinispan.objectfilter.impl.ql.parse.IckleParser;
import org.infinispan.objectfilter.impl.ql.parse.QueryRenderer;
import org.infinispan.objectfilter.impl.ql.parse.QueryResolver;
import org.jboss.logging.Logger;

public final class QueryParser {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)QueryParser.class.getName());

    public CommonTree parseQuery(String queryString, QueryResolverDelegate resolverDelegate, QueryRendererDelegate rendererDelegate) throws ParsingException {
        IckleLexer lexer = new IckleLexer((CharStream)new ANTLRStringStream(queryString));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IckleParser parser = new IckleParser((TokenStream)tokens);
        try {
            IckleParser.statement_return r = parser.statement();
            if (parser.hasErrors()) {
                throw log.getQuerySyntaxException(queryString, parser.getErrorMessages());
            }
            CommonTree tree = (CommonTree)r.getTree();
            tree = this.resolve((TokenStream)tokens, tree, resolverDelegate);
            tree = this.render((TokenStream)tokens, tree, rendererDelegate);
            return tree;
        }
        catch (RecognitionException e) {
            throw log.getQuerySyntaxException(queryString, e);
        }
    }

    private CommonTree resolve(TokenStream tokens, CommonTree tree, QueryResolverDelegate resolverDelegate) throws RecognitionException {
        CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream((Object)tree);
        treeNodeStream.setTokenStream(tokens);
        return (CommonTree)new QueryResolver((TreeNodeStream)treeNodeStream, resolverDelegate).statement().getTree();
    }

    private CommonTree render(TokenStream tokens, CommonTree tree, QueryRendererDelegate rendererDelegate) throws RecognitionException {
        CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream((Object)tree);
        treeNodeStream.setTokenStream(tokens);
        return (CommonTree)new QueryRenderer((TreeNodeStream)treeNodeStream, rendererDelegate).statement().getTree();
    }
}

