/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.server.memcached.MemcachedCompatEncoder;
import org.infinispan.server.memcached.MemcachedMetadataExternalizer;

public class LifecycleCallbacks
extends AbstractModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        globalConfiguration.serialization().advancedExternalizers().put(1101, new MemcachedMetadataExternalizer());
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        CompatibilityModeConfiguration compatibility = configuration.compatibility();
        if (compatibility.enabled()) {
            Marshaller marshaller = compatibility.marshaller();
            cr.getEncoderRegistry().registerEncoder((Encoder)new MemcachedCompatEncoder(marshaller));
        }
        super.cacheStarted(cr, cacheName);
    }
}

