/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.AddWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ByTermUpdateWorkExecutor
extends UpdateWorkExecutor {
    private static final Log log = LoggerFactory.make();
    private final AddWorkExecutor addDelegate;
    private final Workspace workspace;

    ByTermUpdateWorkExecutor(Workspace workspace, AddWorkExecutor addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        Serializable id = work.getId();
        String tenantId = work.getTenantId();
        IndexedTypeIdentifier managedType = work.getEntityType();
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(managedType);
        try {
            if (DeleteWorkExecutor.isIdNumeric(builder)) {
                log.tracef("Deleting %s#%s by query using an IndexWriter#updateDocument as id is Numeric", managedType, id);
                Query exactMatchQuery = NumericFieldUtils.createExactMatchQuery(builder.getIdFieldName(), id);
                BooleanQuery.Builder deleteDocumentsQueryBuilder = new BooleanQuery.Builder();
                deleteDocumentsQueryBuilder.add(exactMatchQuery, BooleanClause.Occur.FILTER);
                if (tenantId != null) {
                    TermQuery tenantTermQuery = new TermQuery(new Term("__HSearch_TenantId", tenantId));
                    deleteDocumentsQueryBuilder.add((Query)tenantTermQuery, BooleanClause.Occur.FILTER);
                }
                delegate.deleteDocuments((Query)deleteDocumentsQueryBuilder.build());
                this.addDelegate.performWork(work, delegate, monitor);
            } else {
                log.tracef("Updating %s#%s by id using an IndexWriter#updateDocument.", managedType, id);
                Term idTerm = new Term(builder.getIdFieldName(), work.getIdInString());
                Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
                ScopedAnalyzerReference analyzerReference = builder.getAnalyzerReference();
                analyzerReference = AddWorkExecutor.updateAnalyzerMappings(this.workspace, analyzerReference, fieldToAnalyzerMap);
                delegate.updateDocument(idTerm, work.getDocument(), analyzerReference);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }
}

