/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.Serializable;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;

public class Work {
    private final Object entity;
    private final IndexedTypeIdentifier entityTypeId;
    private final Serializable id;
    private final WorkType type;
    private final boolean identifierWasRolledBack;
    private final String tenantIdentifier;

    public Work(Object entity, Serializable id, WorkType type) {
        this(null, entity, (IndexedTypeIdentifier)null, id, type, false);
    }

    public Work(Object entity, Serializable id, WorkType type, boolean identifierRollbackEnabled) {
        this(null, entity, (IndexedTypeIdentifier)null, id, type, identifierRollbackEnabled);
    }

    @Deprecated
    public Work(Class<?> entityType, Serializable id, WorkType type) {
        this(null, null, entityType, id, type, false);
    }

    public Work(IndexedTypeIdentifier entityType, Serializable id, WorkType type) {
        this(null, null, entityType, id, type, false);
    }

    public Work(Object entity, WorkType type) {
        this(null, entity, (IndexedTypeIdentifier)null, null, type, false);
    }

    public Work(String tenantId, Object entity, Serializable id, WorkType type) {
        this(tenantId, entity, (IndexedTypeIdentifier)null, id, type, false);
    }

    public Work(String tenantId, Object entity, Serializable id, WorkType type, boolean identifierRollbackEnabled) {
        this(tenantId, entity, (IndexedTypeIdentifier)null, id, type, identifierRollbackEnabled);
    }

    @Deprecated
    public Work(String tenantId, Class<?> entityType, Serializable id, WorkType type) {
        this(tenantId, null, entityType, id, type, false);
    }

    public Work(String tenantId, IndexedTypeIdentifier entityType, Serializable id, WorkType type) {
        this(tenantId, null, entityType, id, type, false);
    }

    public Work(String tenantId, Object entity, WorkType type) {
        this(tenantId, entity, (IndexedTypeIdentifier)null, null, type, false);
    }

    @Deprecated
    private Work(String tenantId, Object entity, Class<?> entityClass, Serializable id, WorkType type, boolean identifierWasRolledBack) {
        this(tenantId, entity, entityClass == null ? null : new PojoIndexedTypeIdentifier(entityClass), id, type, identifierWasRolledBack);
    }

    private Work(String tenantId, Object entity, IndexedTypeIdentifier entityTypeId, Serializable id, WorkType type, boolean identifierWasRolledBack) {
        this.entity = entity;
        this.entityTypeId = entityTypeId;
        this.id = id;
        this.type = type;
        this.identifierWasRolledBack = identifierWasRolledBack;
        this.tenantIdentifier = tenantId;
    }

    @Deprecated
    public Class<?> getEntityClass() {
        return this.entityTypeId != null ? this.entityTypeId.getPojoType() : null;
    }

    public IndexedTypeIdentifier getTypeIdentifier() {
        return this.entityTypeId;
    }

    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Serializable getId() {
        return this.id;
    }

    public WorkType getType() {
        return this.type;
    }

    public boolean isIdentifierWasRolledBack() {
        return this.identifierWasRolledBack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Work{");
        sb.append("entityTypeId=").append(this.entityTypeId);
        sb.append(", tenantId=").append(this.tenantIdentifier);
        sb.append(", id=").append(this.id);
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }
}

