/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Serializable;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class EntityInfoImpl
implements EntityInfo {
    private static final Log log = LoggerFactory.make();
    private final IndexedTypeIdentifier type;
    private final Serializable id;
    private final String idName;
    private final Object[] projection;
    private Object entityInstance;

    public EntityInfoImpl(IndexedTypeIdentifier type, String idName, Serializable id, Object[] projection) {
        this.type = type;
        this.idName = idName;
        this.id = id;
        this.projection = projection;
    }

    @Override
    public IndexedTypeIdentifier getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public Class<?> getClazz() {
        if (this.type == null) {
            throw log.incompleteEntityInfo(null, this.id);
        }
        return this.type.getPojoType();
    }

    @Override
    public Serializable getId() {
        if (this.id == null) {
            throw log.incompleteEntityInfo(this.type, this.id);
        }
        return this.id;
    }

    @Override
    public String getIdName() {
        return this.idName;
    }

    @Override
    public Object[] getProjection() {
        return this.projection;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public void populateWithEntityInstance(Object entity) {
        this.entityInstance = entity;
        for (int i = 0; i < this.projection.length; ++i) {
            if (this.projection[i] != ENTITY_PLACEHOLDER) continue;
            this.projection[i] = entity;
        }
    }

    public String toString() {
        return "EntityInfoImpl{idName='" + this.idName + '\'' + ", id=" + this.id + ", clazz=" + this.type + '}';
    }
}

