/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class SecurityActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static void clearAuthException() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        sc.getData().put(SecurityActions.AUTH_EXCEPTION_KEY, null);
                    }
                    return null;
                }
            });
        } else {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                sc.getData().put(AUTH_EXCEPTION_KEY, null);
            }
        }
    }

    static Throwable getAuthException() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

                @Override
                public Throwable run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    Throwable exception = null;
                    if (sc != null) {
                        exception = (Throwable)sc.getData().get(SecurityActions.AUTH_EXCEPTION_KEY);
                    }
                    return exception;
                }
            });
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        Throwable exception = null;
        if (sc != null) {
            exception = (Throwable)sc.getData().get(AUTH_EXCEPTION_KEY);
        }
        return exception;
    }

    static void startProtocolServer(final ProtocolServer server, final ProtocolServerConfiguration configuration, final EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                server.start(configuration, cacheManager);
                return null;
            }
        };
        SecurityActions.doPrivileged(action);
    }
}

