/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.dialect.impl.DialectIndependentGsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchLogCategories;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.util.logging.impl.LogCategory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchClient
implements ElasticsearchClientImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private static final Log requestLog = (Log)LoggerFactory.make(Log.class, (LogCategory)ElasticsearchLogCategories.REQUEST);
    private final RestClient restClient;
    private final Sniffer sniffer;
    private volatile GsonProvider gsonProvider;

    public DefaultElasticsearchClient(RestClient restClient, Sniffer sniffer) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.gsonProvider = DialectIndependentGsonProvider.INSTANCE;
    }

    @Override
    public void init(GsonProvider gsonProvider) {
        this.gsonProvider = gsonProvider;
    }

    @Override
    public ElasticsearchResponse execute(ElasticsearchRequest request) {
        Response response;
        try {
            response = this.doExecute(request);
        }
        catch (IOException | RuntimeException e) {
            throw log.elasticsearchRequestFailed(ElasticsearchClientUtils.formatRequest(this.gsonProvider, request), null, e);
        }
        try {
            JsonObject body = this.parseBody(response);
            return new ElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), body);
        }
        catch (IOException | RuntimeException e) {
            ElasticsearchResponse partialResponse = new ElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), null);
            throw log.elasticsearchRequestFailed(ElasticsearchClientUtils.formatRequest(this.gsonProvider, request), ElasticsearchClientUtils.formatResponse(this.gsonProvider, partialResponse), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response doExecute(ElasticsearchRequest request) throws IOException {
        Gson gson = this.gsonProvider.getGson();
        HttpEntity entity = ElasticsearchClientUtils.toEntity(gson, request);
        long start = System.nanoTime();
        try {
            Response response = this.restClient.performRequest(request.getMethod(), request.getPath(), request.getParameters(), entity, new Header[0]);
            return response;
        }
        catch (ResponseException e) {
            requestLog.debug("ES client issued a ResponseException - not necessarily a problem", e);
            Response response = e.getResponse();
            return response;
        }
        finally {
            long executionTime = System.nanoTime() - start;
            requestLog.executedRequest(request.getPath(), request.getParameters(), TimeUnit.NANOSECONDS.toMillis(executionTime));
        }
    }

    /*
     * Exception decompiling
     */
    private JsonObject parseBody(Response response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    @Override
    public void close() throws IOException {
        try (RestClient restClient = this.restClient;){
            Sniffer sniffer = this.sniffer;
            Throwable throwable = null;
            if (sniffer != null) {
                if (throwable != null) {
                    try {
                        sniffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    sniffer.close();
                }
            }
        }
    }
}

