/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;

public class JsonBuilder {
    private JsonBuilder() {
    }

    public static Array array() {
        return new Array();
    }

    public static Array array(JsonArray jsonArray) {
        return new Array(jsonArray);
    }

    public static Object object() {
        return new Object();
    }

    public static Object object(JsonObject jsonObject) {
        return new Object(jsonObject);
    }

    public static class Object {
        private JsonObject jsonObject = new JsonObject();

        private Object() {
        }

        private Object(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        public Object add(String property, JsonElement element) {
            this.jsonObject.add(property, element);
            return this;
        }

        public Object add(String property, Array element) {
            this.jsonObject.add(property, (JsonElement)element.build());
            return this;
        }

        public Object add(String property, Object element) {
            this.jsonObject.add(property, (JsonElement)element.build());
            return this;
        }

        public Object addProperty(String property, java.lang.Object value) {
            if (value instanceof String || value == null) {
                this.jsonObject.addProperty(property, (String)value);
            }
            if (value instanceof URLEncodedString) {
                this.addProperty(property, (URLEncodedString)value);
            } else if (value instanceof Number) {
                this.jsonObject.addProperty(property, (Number)value);
            } else if (value instanceof Boolean) {
                this.jsonObject.addProperty(property, (Boolean)value);
            } else if (value instanceof Character) {
                this.jsonObject.addProperty(property, (Character)value);
            } else if (value instanceof Date) {
                this.jsonObject.addProperty(property, ElasticsearchDateHelper.dateToString((Date)value));
            } else if (value instanceof Calendar) {
                this.jsonObject.addProperty(property, ElasticsearchDateHelper.calendarToString((Calendar)value));
            }
            return this;
        }

        public Object addProperty(String property, Boolean value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, Number value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, Character value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, String value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, URLEncodedString value) {
            this.jsonObject.addProperty(property, value.original);
            return this;
        }

        public Object append(JsonAppender<? super Object> appender) {
            appender.append(this);
            return this;
        }

        public JsonObject build() {
            return this.jsonObject;
        }

        public String toString() {
            return this.jsonObject.toString();
        }
    }

    public static class Array {
        private JsonArray jsonArray = new JsonArray();

        private Array() {
        }

        private Array(JsonArray jsonArray) {
            this.jsonArray = jsonArray;
        }

        public Array add(JsonElement element) {
            this.jsonArray.add(element);
            return this;
        }

        public Array add(Array element) {
            this.jsonArray.add((JsonElement)element.build());
            return this;
        }

        public Array add(Object element) {
            this.jsonArray.add((JsonElement)element.build());
            return this;
        }

        public Array append(JsonAppender<? super Array> appender) {
            appender.append(this);
            return this;
        }

        public JsonArray build() {
            return this.jsonArray;
        }

        public String toString() {
            return this.jsonArray.toString();
        }

        public int size() {
            return this.jsonArray.size();
        }
    }

    public static interface JsonAppender<T> {
        public void append(T var1);
    }
}

