/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends org.hibernate.search.util.logging.impl.Log {
    @Message(id=400001, value="Cannot execute query '%2$s', as targeted entity type '%1$s' is not mapped to an Elasticsearch index")
    public SearchException cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=400002, value="Lucene query '%1$s' cannot be transformed into equivalent Elasticsearch query")
    public SearchException cannotTransformLuceneQueryIntoEsQuery(Query var1);

    @Message(id=400004, value="The sort order RANGE_DEFINITION_ORDER cant not be sent used with Elasticsearch")
    public SearchException cannotSendRangeDefinitionOrderToElasticsearchBackend();

    @Message(id=400005, value="The SortType '%1$s' cannot be used with a null sort field name")
    public SearchException cannotUseThisSortTypeWithNullSortFieldName(SortField.Type var1);

    @Message(id=400006, value="Empty phrase queries are not supported")
    public SearchException cannotQueryOnEmptyPhraseQuery();

    @Message(id=400007, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400008, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public BulkRequestFailedException elasticsearchBulkRequestFailed(String var1, String var2, @Param Map<BulkableElasticsearchWork<?>, JsonObject> var3, @Param List<BulkableElasticsearchWork<?>> var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400009, value="Field '%2$s' in '%1$s' requires an Elasticsearch analyzer reference (got '%3$s' instead). The analyzer will be ignored.")
    public void analyzerIsNotElasticsearch(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, AnalyzerReference var3);

    @Message(id=400010, value="Elasticsearch connection time-out; check the cluster status, it should be 'green';\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestTimeout(String var1, String var2);

    @Message(id=400011, value="Projection of non-JSON-primitive field values is not supported: '%1$s'")
    public SearchException unsupportedProjectionOfNonJsonPrimitiveFields(JsonElement var1);

    @Message(id=400012, value="Interrupted while waiting for requests to be processed.")
    public SearchException interruptedWhileWaitingForRequestCompletion(@Cause Exception var1);

    @Message(id=400013, value="@Factory method does not return a Filter class or an ElasticsearchFilter class: %1$s.%2$s")
    public SearchException filterFactoryMethodReturnsUnsupportedType(String var1, String var2);

    @Message(id=400014, value="Unable to access @Factory method: %1$s.%2$s")
    public SearchException filterFactoryMethodInaccessible(String var1, String var2, @Cause Exception var3);

    @Message(id=400015, value="Filter implementation does not implement the Filter interface or the ElasticsearchFilter interface: %1$s")
    public SearchException filterHasUnsupportedType(String var1);

    @Message(id=400016, value="TopDocs not available when using Elasticsearch")
    public UnsupportedOperationException documentExtractorTopDocsUnsupported();

    @Message(id=400017, value="Cannot use Lucene query with Elasticsearch")
    public UnsupportedOperationException hsQueryLuceneQueryUnsupported();

    @Message(id=400018, value="Unexpected numeric encoding type for field '%2$s' on entity type '%1$s'. If you used a custom field bridge, make sure it implements MetadataProvidingFieldBridge and provides metadata for this field.")
    public SearchException unexpectedNumericEncodingType(String var1, String var2);

    @Message(id=400020, value="Could not create mapping for entity type %1$s")
    public SearchException elasticsearchMappingCreationFailed(Object var1, @Cause Exception var2);

    @Message(id=400021, value="Unexpected field type for field '%2$s': %1$s")
    public SearchException unexpectedFieldType(String var1, String var2);

    @Message(id=400022, value="Unexpected index status string: '%1$s'. Specify one of 'green', 'yellow' or 'red'.")
    public SearchException unexpectedIndexStatusString(String var1);

    @Message(id=400023, value="Positive timeout value expected, but it was: %1$s")
    public SearchException negativeTimeoutValue(int var1);

    @Message(id=400024, value="Timed out while waiting for for index '%1$s' to reach status '%2$s'; status was still '%3$s' after %4$s.")
    public SearchException unexpectedIndexStatus(String var1, String var2, String var3, String var4);

    @Message(id=400025, value="With an Elasticsearch backend it is not possible to get a ReaderProvider or an IndexReader")
    public UnsupportedOperationException indexManagerReaderProviderUnsupported();

    @Message(id=400026, value="Faceting request of type %1$s not supported")
    public SearchException facetingRequestHasUnsupportedType(String var1);

    @Message(id=400027, value="The 'indexNullAs' property for Boolean fields must represent a Boolean ('true' or 'false').")
    public IllegalArgumentException invalidNullMarkerForBoolean();

    @Message(id=400028, value="The 'indexNullAs' property for Calendar and Date fields must represent a date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ).")
    public IllegalArgumentException invalidNullMarkerForCalendarAndDate(@Cause Exception var1);

    @Message(id=400029, value="Cannot use an offset ('from', 'firstResult') when scrolling through Elasticsearch results")
    public UnsupportedOperationException unsupportedOffsettedScrolling();

    @Message(id=400030, value="Cannot scroll backward through Elasticsearch results. Previously accessed index was %1$s, requested index is %2$s.")
    public UnsupportedOperationException unsupportedBackwardTraversal(int var1, int var2);

    @Message(id=400031, value="Cannot scroll backward more than %1$s positions through Elasticsearch results. First index still in memory is %2$s, requested index is %3$s.")
    public SearchException backtrackingWindowOverflow(int var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400032, value="@DynamicBoost is not supported with Elasticsearch. Ignoring boost strategy '%1$s' for entity '%2$s' (field path '%3$s').")
    public void unsupportedDynamicBoost(Class<?> var1, Class<?> var2, String var3);

    @Message(id=400033, value="An Elasticsearch schema validation failed: %1$s")
    public ElasticsearchSchemaValidationException schemaValidationFailed(String var1);

    @Message(id=400034, value="Could not retrieve the mappings from Elasticsearch for validation")
    public SearchException elasticsearchMappingRetrievalForValidationFailed(@Cause Exception var1);

    @Message(id=400035, value="Could not update mappings in index '%1$s'")
    public SearchException schemaUpdateFailed(Object var1, @Cause Exception var2);

    @Message(id=400036, value="Mapping conflict detected for field '%2$s' on entity '%1$s'. The current mapping would require the field to be mapped to both a composite field ('object' datatype) and a \"concrete\" field ('integer', 'date', etc.) holding a value, which Elasticsearch does not allow. If you're seeing this issue, you probably added both an @IndexedEmbedded annotation and a @Field (or similar) annotation on the same property: if that's the case, please set either @IndexedEmbedded.prefix or @Field.name to a custom value different from the default to resolve the conflict.")
    public SearchException fieldIsBothCompositeAndConcrete(Class<?> var1, String var2);

    @Message(id=400037, value="The 'indexNullAs' property for Period fields must represent a date interval in ISO-8601 format (for instance P3Y2M1D for 3 years, 2 months and 1 day).")
    public IllegalArgumentException invalidNullMarkerForPeriod(@Cause Exception var1);

    @Message(id=400038, value="The 'indexNullAs' property for Duration fields must represent a duration in ISO-8601 format (for instance P1DT2H3M4.007S for 1 day, 2 hours, 3 minutes, 4 seconds and 7 miliseconds).")
    public IllegalArgumentException invalidNullMarkerForDuration(@Cause Exception var1);

    @Message(id=400039, value="The 'indexNullAs' property for Instant fields must represent a date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ[ZZZ]).")
    public IllegalArgumentException invalidNullMarkerForInstant(@Cause Exception var1);

    @Message(id=400040, value="The 'indexNullAs' property for LocalDateTime fields must represent a local date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ss).")
    public IllegalArgumentException invalidNullMarkerForLocalDateTime(@Cause Exception var1);

    @Message(id=400041, value="The 'indexNullAs' property for LocalDate fields must represent a local date in ISO-8601 format (yyyy-MM-dd).")
    public IllegalArgumentException invalidNullMarkerForLocalDate(@Cause Exception var1);

    @Message(id=400042, value="The 'indexNullAs' property for LocalTime fields must represent a local time in ISO-8601 format (HH:mm:ss).")
    public IllegalArgumentException invalidNullMarkerForLocalTime(@Cause Exception var1);

    @Message(id=400043, value="The 'indexNullAs' property for OffsetDateTime fields must represent an offset date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ssZ).")
    public IllegalArgumentException invalidNullMarkerForOffsetDateTime(@Cause Exception var1);

    @Message(id=400044, value="The 'indexNullAs' property for OffsetTime fields must represent an offset time in ISO-8601 format (HH:mm:ssZ).")
    public IllegalArgumentException invalidNullMarkerForOffsetTime(@Cause Exception var1);

    @Message(id=400045, value="The 'indexNullAs' property for ZonedDateTime fields must represent a zoned date/time in ISO-8601 format (yyyy-MM-dd'T'HH:mm:ss[ZZZ]).")
    public IllegalArgumentException invalidNullMarkerForZonedDateTime(@Cause Exception var1);

    @Message(id=400046, value="The 'indexNullAs' property for ZonedTime fields must represent a zoned time in ISO-8601 format (HH:mm:ss[ZZZ]).")
    public IllegalArgumentException invalidNullMarkerForZonedTime(@Cause Exception var1);

    @Message(id=400047, value="The 'indexNullAs' property for Year fields must represent a year in ISO-8601 format (for instance 2014).")
    public IllegalArgumentException invalidNullMarkerForYear(@Cause Exception var1);

    @Message(id=400048, value="The 'indexNullAs' property for YearMonth fields must represent a year/month in ISO-8601 format (yyyy-MM-dd).")
    public IllegalArgumentException invalidNullMarkerForYearMonth(@Cause Exception var1);

    @Message(id=400049, value="The 'indexNullAs' property for MonthDay fields must represent a month/day in ISO-8601 format (--MM-dd).")
    public IllegalArgumentException invalidNullMarkerForMonthDay(@Cause Exception var1);

    @Message(id=400050, value="The index '%1$s' does not exist in the Elasticsearch cluster.")
    public SearchException indexMissing(Object var1);

    @Message(id=400051, value="The given payload contains unsupported attributes: %1$s. Only 'query' is supported.")
    public SearchException unsupportedSearchAPIPayloadAttributes(List<String> var1);

    @Message(id=400052, value="The given payload is not a valid JSON object.")
    public SearchException invalidSearchAPIPayload(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400053, value="Executing Elasticsearch query on '%s' with parameters '%s' :\n%s")
    public void executingElasticsearchQuery(String var1, Map<String, String> var2, String var3);

    @Message(id=400054, value="Invalid field path detected for field '%2$s' on entity '%1$s': the field name is not prefixed with '%3$s' as it should. This probably means that the field was created with a custom field bridge which added fields with an arbitrary name, not taking the name passed as a parameter into account. This is not supported with the Elasticsearch indexing service: please only add suffixes to the name passed as a parameter to the various bridge methods and never ignore this name.")
    public SearchException indexedEmbeddedPrefixBypass(Class<?> var1, String var2, String var3);

    @Message(id=400055, value="The same tokenizer name '%1$s' is assigned to multiple definitions. The tokenizer names must be unique. If you used the @TokenizerDef annotation and this name was automatically generated, you may override this name by using @TokenizerDef.name.")
    public SearchException tokenizerNamingConflict(String var1);

    @Message(id=400056, value="The same char filter name '%1$s' is assigned to multiple definitions. The char filter names must be unique. If you used the @CharFilterDef annotation and this name was automatically generated, you may override this name by using @CharFilterDef.name.")
    public SearchException charFilterNamingConflict(String var1);

    @Message(id=400057, value="The same token filter name '%1$s' is assigned to multiple definitions. The token filter names must be unique. If you used the @TokenFilterDef annotation and this name was automatically generated, you may override this name by using @TokenFilterDef.name.")
    public SearchException tokenFilterNamingConflict(String var1);

    @Message(id=400058, value="The char filter factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.")
    public SearchException unsupportedCharFilterFactory(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=400059, value="The tokenizer factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.")
    public SearchException unsupportedTokenizerFactory(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=400060, value="The token filter factory '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene factories that have a builtin equivalent in Elasticsearch.")
    public SearchException unsupportedTokenFilterFactory(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=400061, value="The parameter '%2$s' is not supported for the factory '%1$s' with Elasticsearch.")
    public SearchException unsupportedAnalysisFactoryParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=400062, value="The parameter '%2$s' for the factory '%1$s' refers to the class '%3$s', which cannot be converted to a builtin Elasticsearch tokenizer type.")
    public SearchException unsupportedAnalysisFactoryTokenizerClassNameParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3);

    @Message(id=400063, value="The parameter '%2$s' for the factory '%1$s' has an unsupported value: '%3$s' is unsupported with Elasticsearch.")
    public SearchException unsupportedAnalysisDefinitionParameterValue(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3);

    @Message(id=400064, value="The analyzer implementation '%1$s' is not supported with Elasticsearch. Please only use builtin Lucene analyzers that have a builtin equivalent in Elasticsearch.")
    public SearchException unsupportedAnalyzerImplementation(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=400065, value="The parameter '%2$s' for the factory '%1$s' could not be parsed as a JSON string: %3$s")
    public SearchException invalidAnalysisDefinitionJsonStringParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause Exception var4);

    @Message(id=400066, value="The parameter '%2$s' for the factory '%1$s' could not be parsed as JSON: %3$s")
    public SearchException invalidAnalysisDefinitionJsonParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause Exception var4);

    @Message(id=400067, value="Could not update settings for index '%1$s'")
    public SearchException elasticsearchSettingsUpdateFailed(Object var1, @Cause Exception var2);

    @Message(id=400068, value="Could not retrieve the index settings from Elasticsearch for validation")
    public SearchException elasticsearchIndexSettingsRetrievalForValidationFailed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400069, value="Closed Elasticsearch index '%1$s' automatically.")
    public void closedIndex(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400070, value="Opened Elasticsearch index '%1$s' automatically.")
    public void openedIndex(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=400071, value="Failed to open Elasticsearch index '%1$s' ; see the stack trace below.")
    public void failedToOpenIndex(Object var1);

    @Message(id=400072, value="DeleteByQuery request to Elasticsearch failed with 404 result code.\nPlease check that 1. you installed the delete-by-query plugin on your Elasticsearch nodes and 2. the targeted index exists\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearch2RequestDeleteByQueryNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400073, value="Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.")
    public void usingPasswordOverHttp(String var1);

    @Message(id=400074, value="The same analyzer name '%1$s' is assigned to multiple definitions. The analyzer names must be unique.")
    public SearchException analyzerNamingConflict(String var1);

    @Message(id=400075, value="Property 'hibernate.search.elasticsearch.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement ElasticsearchAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a ElasticsearchAnalyzerDefinitionProvider.")
    public SearchException invalidElasticsearchAnalyzerDefinitionProvider(String var1, @Cause Exception var2);

    @Message(id=400076, value="Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.")
    public SearchException invalidElasticsearchAnalyzerDefinition(String var1);

    @Message(id=400077, value="Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.")
    public SearchException invalidElasticsearchTokenizerDefinition(String var1);

    @Message(id=400078, value="Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.")
    public SearchException invalidElasticsearchCharFilterDefinition(String var1);

    @Message(id=400079, value="Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.")
    public SearchException invalidElasticsearchTokenFilterDefinition(String var1);

    @Message(id=400080, value="Failed to detect the Elasticsearch version running on the cluster.")
    public SearchException failedToDetectElasticsearchVersion(@Cause Exception var1);

    @Message(id=400081, value="An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.")
    public SearchException unsupportedElasticsearchVersion(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400082, value="Executed Elasticsearch HTTP request to path '%s' with query parameters %s in %dms")
    public void executedRequest(String var1, Map<String, String> var2, long var3);

    @Message(id=400083, value="For simple query string queries, Elasticsearch does not support overriding fields with more than one different analyzers: %1$s.")
    public SearchException unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries(Collection<String> var1);

    @Message(id=400084, value="The parameter '%2$s' must have value '%3$s' for the factory '%1$s' with Elasticsearch. Current value '%4$s' is invalid.")
    public SearchException invalidAnalysisFactoryParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400085, value="Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.")
    public void unexpectedElasticsearchVersion(String var1);

    @Message(id=400086, value="The same normalizer name '%1$s' is assigned to multiple definitions. The analyzer names must be unique.")
    public SearchException normalizerNamingConflict(String var1);

    @Message(id=400087, value="The same name '%1$s' is assigned to a normalizer definition and an analyzer definition. This is not possible on Elasticsearch 5.1 and below, since normalizers are translated to analyzers under the hood.")
    public SearchException analyzerNormalizerNamingConflict(String var1);

    @Message(id=400088, value="You cannot use @Normalizer(impl = \"%1$s\") on entities mapped to Elasticsearch: there are no built-in normalizers in Elasticsearch. Use @Normalizer(definition = \"...\") instead.")
    public SearchException cannotUseNormalizerImpl(@FormatWith(value=ClassFormatter.class) Class<?> var1);
}

