/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.exception.SearchException;

public class DefaultElasticsearchSchemaDropper
implements ElasticsearchSchemaDropper {
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public DefaultElasticsearchSchemaDropper(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    @Override
    public void drop(URLEncodedString indexName, ExecutionOptions executionOptions) {
        this.schemaAccessor.dropIndex(indexName, executionOptions);
    }

    @Override
    public void dropIfExisting(URLEncodedString indexName, ExecutionOptions executionOptions) {
        block3: {
            if (!this.schemaAccessor.indexExists(indexName)) {
                return;
            }
            try {
                this.schemaAccessor.dropIndex(indexName, executionOptions);
            }
            catch (SearchException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block3;
                throw e;
            }
        }
    }
}

