/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.AnalysisDefinitionFactory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class JsonPassThroughAnalysisDefinitionFactory<D extends AnalysisDefinition>
implements AnalysisDefinitionFactory<D> {
    static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final Class<D> targetClass;
    private final Class<?> factoryClass;
    private final JsonParser jsonParser = new JsonParser();

    public JsonPassThroughAnalysisDefinitionFactory(Class<D> targetClass, Class<?> factoryClass) {
        this.targetClass = targetClass;
        this.factoryClass = factoryClass;
    }

    @Override
    public String getType() {
        throw new UnsupportedOperationException("This factory defines the definition type based on the Hibernate Search parameters.");
    }

    @Override
    public D create(Map<String, String> parameters) {
        AnalysisDefinition result;
        try {
            result = (AnalysisDefinition)this.targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionFailure("Unexpected failure while instanciating a definition", (Throwable)e);
        }
        LinkedHashMap<String, JsonElement> parameterMap = new LinkedHashMap<String, JsonElement>();
        block8: for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            String value = parameter.getValue();
            switch (name) {
                case "type": {
                    result.setType(this.parseJsonString(name, value));
                    continue block8;
                }
            }
            parameterMap.put(name, this.parseJson(name, value));
        }
        if (!parameterMap.isEmpty()) {
            result.setParameters(parameterMap);
        }
        return (D)result;
    }

    private String parseJsonString(String name, String value) {
        try {
            return this.jsonParser.parse(value).getAsJsonPrimitive().getAsString();
        }
        catch (JsonParseException | ClassCastException | IllegalStateException e) {
            throw LOG.invalidAnalysisDefinitionJsonStringParameter(this.factoryClass, name, e.getLocalizedMessage(), (Exception)e);
        }
    }

    private JsonElement parseJson(String name, String value) {
        try {
            return this.jsonParser.parse(value);
        }
        catch (JsonParseException e) {
            throw LOG.invalidAnalysisDefinitionJsonParameter(this.factoryClass, name, e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "targetClass = " + this.targetClass + "]";
    }
}

