/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.CreateIndexResult;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.CreateIndexWorkBuilder;

public class CreateIndexWork
extends SimpleElasticsearchWork<CreateIndexResult> {
    protected CreateIndexWork(Builder builder) {
        super(builder);
    }

    @Override
    protected CreateIndexResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        int statusCode = response.getStatusCode();
        if (ElasticsearchClientUtils.isSuccessCode(statusCode)) {
            return CreateIndexResult.CREATED;
        }
        return CreateIndexResult.ALREADY_EXISTS;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements CreateIndexWorkBuilder {
        private final GsonProvider gsonProvider;
        private final URLEncodedString indexName;
        private JsonObject payload;

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.gsonProvider = gsonProvider;
            this.indexName = indexName;
        }

        @Override
        public Builder settings(IndexSettings settings) {
            if (settings != null) {
                Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
                this.payload = gson.toJsonTree((Object)settings).getAsJsonObject();
            }
            return this;
        }

        @Override
        public Builder ignoreExisting() {
            this.resultAssessor = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorTypes("index_already_exists_exception").build();
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName);
            if (this.payload != null) {
                builder.body(this.payload);
            }
            return builder.build();
        }

        @Override
        public CreateIndexWork build() {
            return new CreateIndexWork(this);
        }
    }
}

