/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.Attribute;
import org.infinispan.server.endpoint.subsystem.AuthenticationResource;
import org.infinispan.server.endpoint.subsystem.CommonConnectorResource;
import org.infinispan.server.endpoint.subsystem.Element;
import org.infinispan.server.endpoint.subsystem.EncryptionResource;
import org.infinispan.server.endpoint.subsystem.MemcachedConnectorResource;
import org.infinispan.server.endpoint.subsystem.Namespace;
import org.infinispan.server.endpoint.subsystem.PrefixResource;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestAuthenticationResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.RouterConnectorResource;
import org.infinispan.server.endpoint.subsystem.RouterHotRodResource;
import org.infinispan.server.endpoint.subsystem.RouterRestResource;
import org.infinispan.server.endpoint.subsystem.SaslPolicyResource;
import org.infinispan.server.endpoint.subsystem.SaslPropertyResource;
import org.infinispan.server.endpoint.subsystem.SaslResource;
import org.infinispan.server.endpoint.subsystem.SniResource;
import org.infinispan.server.endpoint.subsystem.TopologyStateTransferResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EndpointSubsystemReader
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    private final Namespace namespace;

    EndpointSubsystemReader(Namespace namespace) {
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{Constants.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        operations.add(subsystem);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HOTROD_CONNECTOR: {
                    this.parseHotRodConnector(reader, subsystemAddress, operations);
                    continue block7;
                }
                case MEMCACHED_CONNECTOR: {
                    this.parseMemcachedConnector(reader, subsystemAddress, operations);
                    continue block7;
                }
                case REST_CONNECTOR: {
                    this.parseRestConnector(reader, subsystemAddress, operations);
                    continue block7;
                }
                case WEBSOCKET_CONNECTOR: {
                    this.parseWebSocketConnector(reader, subsystemAddress, operations);
                    continue block7;
                }
                case ROUTER_CONNECTOR: {
                    this.parseRouterConnector(reader, subsystemAddress, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHotRodConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "hotrod-connector";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            name = this.parseConnectorAttributes(reader, connector, name, i, value, attribute);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"hotrod-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        operations.add(connector);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TOPOLOGY_STATE_TRANSFER: {
                    this.parseTopologyStateTransfer(reader, connector, operations);
                    continue block6;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, connector, operations);
                    continue block6;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, connector, operations);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMemcachedConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "memcached-connector";
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CACHE: {
                    MemcachedConnectorResource.CACHE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseConnectorAttributes(reader, connector, name, i, value, attribute);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"memcached-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(connector);
    }

    private String parseConnectorAttributes(XMLExtendedStreamReader reader, ModelNode connector, String name, int i, String value, Attribute attribute) throws XMLStreamException {
        switch (attribute) {
            case IGNORED_CACHES: {
                if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_8_0)) {
                    reader.getListAttributeValue(i).forEach(a -> connector.get("ignored-caches").add(a));
                    break;
                }
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            case CACHE_CONTAINER: {
                CommonConnectorResource.CACHE_CONTAINER.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case IDLE_TIMEOUT: {
                ProtocolServerConnectorResource.IDLE_TIMEOUT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case NAME: {
                CommonConnectorResource.NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                name = value;
                break;
            }
            case RECEIVE_BUFFER_SIZE: {
                ProtocolServerConnectorResource.RECEIVE_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case SEND_BUFFER_SIZE: {
                ProtocolServerConnectorResource.SEND_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case SOCKET_BINDING: {
                ProtocolServerConnectorResource.SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case TCP_NODELAY: {
                ProtocolServerConnectorResource.TCP_NODELAY.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case WORKER_THREADS: {
                ProtocolServerConnectorResource.WORKER_THREADS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
        }
        return name;
    }

    private String parseRouterConnectorAttributes(XMLExtendedStreamReader reader, ModelNode connector, String name, int i, String value, Attribute attribute) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                RouterConnectorResource.NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                name = value;
                break;
            }
            case REST_SOCKET_BINDING: {
                RouterConnectorResource.REST_SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case TCP_NODELAY: {
                RouterConnectorResource.TCP_NODELAY.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case KEEP_ALIVE: {
                RouterConnectorResource.KEEP_ALIVE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case SEND_BUFFER_SIZE: {
                RouterConnectorResource.SEND_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case RECEIVE_BUFFER_SIZE: {
                RouterConnectorResource.RECEIVE_BUFFER_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            case HOTROD_SOCKET_BINDING: {
                RouterConnectorResource.HOTROD_SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
        }
        return name;
    }

    private void parseRestConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "rest-connector";
        block17: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOCKET_BINDING: {
                    RestConnectorResource.SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block17;
                }
                case AUTH_METHOD: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    EndpointLogger.ROOT_LOGGER.restAuthMethodIgnored();
                    continue block17;
                }
                case CACHE_CONTAINER: {
                    CommonConnectorResource.CACHE_CONTAINER.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block17;
                }
                case CONTEXT_PATH: {
                    RestConnectorResource.CONTEXT_PATH.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block17;
                }
                case EXTENDED_HEADERS: {
                    RestConnectorResource.EXTENDED_HEADERS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block17;
                }
                case NAME: {
                    CommonConnectorResource.NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    name = value;
                    continue block17;
                }
                case SECURITY_DOMAIN: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    EndpointLogger.ROOT_LOGGER.restSecurityDomainIgnored();
                }
                case SECURITY_MODE: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    EndpointLogger.ROOT_LOGGER.restSecurityModeIgnored();
                    continue block17;
                }
                case SECURITY_REALM: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    EndpointLogger.ROOT_LOGGER.restSecurityRealmIgnored();
                    continue block17;
                }
                case VIRTUAL_HOST: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    EndpointLogger.ROOT_LOGGER.virtualHostNotInUse();
                    continue block17;
                }
                case IGNORED_CACHES: {
                    if (this.namespace.since(Namespace.INFINISPAN_ENDPOINT_8_0)) {
                        reader.getListAttributeValue(i).forEach(a -> connector.get("ignored-caches").add(a));
                        continue block17;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathAddress containerAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"rest-connector", (String)name)});
        connector.get("address").set(containerAddress.toModelNode());
        operations.add(connector);
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseRestAuthentication(reader, connector, operations);
                    continue block18;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, connector, operations);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRestAuthentication(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"authentication", (String)"AUTHENTICATION")});
        ModelNode authentication = Util.createAddOperation((PathAddress)address);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    RestAuthenticationResource.SECURITY_REALM.parseAndSetParameter(value, authentication, (XMLStreamReader)reader);
                    continue block4;
                }
                case AUTH_METHOD: {
                    RestAuthenticationResource.AUTH_METHOD.parseAndSetParameter(value, authentication, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(authentication);
    }

    private void parseWebSocketConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "websocket-connector";
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            name = this.parseConnectorAttributes(reader, connector, name, i, value, attribute);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"websocket-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(connector);
    }

    private void parseRouterConnector(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode connector = Util.getEmptyOperation((String)"add", null);
        String name = "router-connector";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            name = this.parseRouterConnectorAttributes(reader, connector, name, i, value, attribute);
        }
        PathAddress connectorAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"router-connector", (String)name)});
        connector.get("address").set(connectorAddress.toModelNode());
        operations.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case MULTI_TENANCY: {
                    this.parseMultiTenancy(reader, connector, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTopologyStateTransfer(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"topology-state-transfer", (String)"TOPOLOGY_STATE_TRANSFER")});
        ModelNode topologyStateTransfer = Util.createAddOperation((PathAddress)address);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_RETRIEVAL: {
                    TopologyStateTransferResource.AWAIT_INITIAL_RETRIEVAL.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case EXTERNAL_HOST: {
                    TopologyStateTransferResource.EXTERNAL_HOST.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case EXTERNAL_PORT: {
                    TopologyStateTransferResource.EXTERNAL_PORT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case LAZY_RETRIEVAL: {
                    TopologyStateTransferResource.LAZY_RETRIEVAL.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case LOCK_TIMEOUT: {
                    TopologyStateTransferResource.LOCK_TIMEOUT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case REPLICATION_TIMEOUT: {
                    TopologyStateTransferResource.REPLICATION_TIMEOUT.parseAndSetParameter(value, topologyStateTransfer, (XMLStreamReader)reader);
                    continue block10;
                }
                case UPDATE_TIMEOUT: {
                    EndpointLogger.ROOT_LOGGER.topologyUpdateTimeoutIgnored();
                    continue block10;
                }
                case CACHE_SUFFIX: {
                    EndpointLogger.ROOT_LOGGER.topologyCacheSuffixIgnored();
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(topologyStateTransfer);
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"authentication", (String)"AUTHENTICATION")});
        ModelNode authentication = Util.createAddOperation((PathAddress)address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    AuthenticationResource.SECURITY_REALM.parseAndSetParameter(value, authentication, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        operations.add(authentication);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSasl(reader, authentication, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMultiTenancy(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"multi-tenancy", (String)"MULTI_TENANCY")});
        ModelNode multiTenancy = Util.createAddOperation((PathAddress)address);
        operations.add(multiTenancy);
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HOTROD: {
                    this.parseHotRod(reader, multiTenancy, operations);
                    continue block4;
                }
                case REST: {
                    this.parseRest(reader, multiTenancy, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSasl(XMLExtendedStreamReader reader, ModelNode authentication, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)authentication.get("address")).append(new PathElement[]{PathElement.pathElement((String)"sasl", (String)"SASL")});
        ModelNode sasl = Util.createAddOperation((PathAddress)address);
        list.add(sasl);
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MECHANISMS: {
                    for (String mech : reader.getListAttributeValue(i)) {
                        SaslResource.MECHANISMS.parseAndAddParameterElement(mech, sasl, (XMLStreamReader)reader);
                    }
                    continue block11;
                }
                case QOP: {
                    for (String qop : reader.getListAttributeValue(i)) {
                        SaslResource.QOP.parseAndAddParameterElement(qop, sasl, (XMLStreamReader)reader);
                    }
                    continue block11;
                }
                case SERVER_CONTEXT_NAME: {
                    SaslResource.SERVER_CONTEXT_NAME.parseAndSetParameter(value, sasl, (XMLStreamReader)reader);
                    continue block11;
                }
                case SERVER_NAME: {
                    SaslResource.SERVER_NAME.parseAndSetParameter(value, sasl, (XMLStreamReader)reader);
                    continue block11;
                }
                case STRENGTH: {
                    for (String strength : reader.getListAttributeValue(i)) {
                        SaslResource.STRENGTH.parseAndAddParameterElement(strength, sasl, (XMLStreamReader)reader);
                    }
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case POLICY: {
                    if (visited.contains((Object)element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    visited.add(element);
                    this.parsePolicy(reader, sasl, list);
                    continue block15;
                }
                case PROPERTY: {
                    this.parseProperty(reader, sasl, list);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parsePolicy(XMLExtendedStreamReader reader, ModelNode sasl, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)sasl.get("address")).append(new PathElement[]{PathElement.pathElement((String)"sasl-policy", (String)"SASL_POLICY")});
        ModelNode policy = Util.createAddOperation((PathAddress)address);
        list.add(policy);
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case FORWARD_SECRECY: {
                    SaslPolicyResource.FORWARD_SECRECY.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_ACTIVE: {
                    SaslPolicyResource.NO_ACTIVE.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_ANONYMOUS: {
                    SaslPolicyResource.NO_ANONYMOUS.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_DICTIONARY: {
                    SaslPolicyResource.NO_DICTIONARY.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case NO_PLAIN_TEXT: {
                    SaslPolicyResource.NO_PLAIN_TEXT.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
                case PASS_CREDENTIALS: {
                    SaslPolicyResource.PASS_CREDENTIALS.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), policy, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode node, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String propertyName = reader.getAttributeValue(0);
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = PathAddress.pathAddress((ModelNode)node.get("address")).append("property", propertyName);
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        SaslPropertyResource.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.add(property);
    }

    private void parseEncryption(XMLExtendedStreamReader reader, ModelNode connector, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)connector.get("address")).append(new PathElement[]{PathElement.pathElement((String)"encryption", (String)"ENCRYPTION")});
        ModelNode security = Util.createAddOperation((PathAddress)address);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    EncryptionResource.REQUIRE_SSL_CLIENT_AUTH.parseAndSetParameter(value, security, (XMLStreamReader)reader);
                    continue block7;
                }
                case SECURITY_REALM: {
                    EncryptionResource.SECURITY_REALM.parseAndSetParameter(value, security, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        operations.add(security);
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    if (!this.namespace.since(Namespace.INFINISPAN_ENDPOINT_9_0)) break;
                    this.parseSni(reader, security, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, ModelNode encryption, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.HOST_NAME.getLocalName()});
        String hostName = reader.getAttributeValue(null, Attribute.HOST_NAME.getLocalName());
        PathAddress sniOpAddress = PathAddress.pathAddress((ModelNode)encryption.get("address")).append("sni", hostName);
        ModelNode sniOp = Util.createAddOperation((PathAddress)sniOpAddress);
        SniResource.HOST_NAME.parseAndSetParameter(hostName, sniOp, (XMLStreamReader)reader);
        String securityRealm = reader.getAttributeValue(null, Attribute.SECURITY_REALM.getLocalName());
        SniResource.SECURITY_REALM.parseAndSetParameter(securityRealm, sniOp, (XMLStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(sniOp);
    }

    private void parsePrefix(XMLExtendedStreamReader reader, ModelNode prefix, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.PATH.getLocalName()});
        String path = reader.getAttributeValue(null, Attribute.PATH.getLocalName());
        PathAddress pathOpAddress = PathAddress.pathAddress((ModelNode)prefix.get("address")).append("prefix", path);
        ModelNode pathOp = Util.createAddOperation((PathAddress)pathOpAddress);
        PrefixResource.PATH.parseAndSetParameter(path, pathOp, (XMLStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(pathOp);
    }

    private void parseHotRod(XMLExtendedStreamReader reader, ModelNode multiTenancy, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName()});
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        PathAddress hotrodOpAddress = PathAddress.pathAddress((ModelNode)multiTenancy.get("address")).append("hotrod", name);
        ModelNode hotrodOp = Util.createAddOperation((PathAddress)hotrodOpAddress);
        RouterHotRodResource.NAME.parseAndSetParameter(name, hotrodOp, (XMLStreamReader)reader);
        operations.add(hotrodOp);
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, hotrodOp, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRest(XMLExtendedStreamReader reader, ModelNode multiTenancy, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName()});
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        PathAddress restOpAddress = PathAddress.pathAddress((ModelNode)multiTenancy.get("address")).append("rest", name);
        ModelNode restOp = Util.createAddOperation((PathAddress)restOpAddress);
        RouterRestResource.NAME.parseAndSetParameter(name, restOp, (XMLStreamReader)reader);
        operations.add(restOp);
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PREFIX: {
                    this.parsePrefix(reader, restOp, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }
}

