/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.infinispan.rest.Server;
import org.infinispan.rest.embedded.netty4.NettyRestServer;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.MultiTenantRouter;
import org.infinispan.server.router.configuration.builder.HotRodRouterBuilder;
import org.infinispan.server.router.configuration.builder.MultiTenantRouterConfigurationBuilder;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.NettyHandlerRouteDestination;
import org.infinispan.server.router.routes.hotrod.SniNettyRouteSource;
import org.infinispan.server.router.routes.rest.NettyRestServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestRouteSource;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class MultiTenantRouterService
implements Service<MultiTenantRouter> {
    private static final String DEFAULT_NAME = "Multitenant Router";
    private final InjectedValue<SocketBinding> restSocketBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> hotrodSocketBinding = new InjectedValue();
    private final Map<String, HotRodRouting> hotrodRouting = new HashMap<String, HotRodRouting>();
    private final Map<String, RestRouting> restRouting = new HashMap<String, RestRouting>();
    private final String name;
    private final MultiTenantRouterConfigurationBuilder configurationBuilder;
    private MultiTenantRouter router;

    MultiTenantRouterService(MultiTenantRouterConfigurationBuilder configurationBuilder, Optional<String> serverName) {
        this.name = this.constructServerName(serverName);
        this.configurationBuilder = configurationBuilder;
    }

    private final String constructServerName(Optional<String> name) {
        return name.orElse(DEFAULT_NAME);
    }

    public synchronized void start(StartContext context) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting(this.name);
        try {
            InetSocketAddress restAddress;
            SocketBinding hotrodSocketBinding = (SocketBinding)this.getHotrodSocketBinding().getOptionalValue();
            InetSocketAddress hotrodAddress = hotrodSocketBinding != null ? hotrodSocketBinding.getSocketAddress() : null;
            SocketBinding restSocketBinding = (SocketBinding)this.getRestSocketBinding().getOptionalValue();
            InetSocketAddress inetSocketAddress = restAddress = restSocketBinding != null ? restSocketBinding.getSocketAddress() : null;
            if (hotrodAddress != null) {
                HotRodRouterBuilder hotrodConfigurationBuilder = this.configurationBuilder.hotrod();
                hotrodConfigurationBuilder.ip(hotrodAddress.getAddress());
                hotrodConfigurationBuilder.port(hotrodAddress.getPort());
            }
            if (restAddress != null) {
                this.configurationBuilder.rest().ip(restAddress.getAddress());
                this.configurationBuilder.rest().port(restAddress.getPort());
            }
            this.hotrodRouting.forEach((sniHostName, routing) -> {
                HotRodServer hotRod = (HotRodServer)routing.getHotRod().getValue();
                SecurityRealm securityRealm = (SecurityRealm)routing.getSecurityRealm().getValue();
                SniNettyRouteSource source = new SniNettyRouteSource(sniHostName, securityRealm.getSSLContext());
                NettyHandlerRouteDestination destination = new NettyHandlerRouteDestination(hotRod.getQualifiedName(), hotRod.getInitializer());
                this.configurationBuilder.routing().add(new Route((RouteSource)source, (RouteDestination)destination));
            });
            this.restRouting.forEach((path, routing) -> {
                Server restResource = ((NettyRestServer)routing.getRest().getValue()).getServer();
                String name = routing.getName();
                RestRouteSource source = new RestRouteSource(path);
                NettyRestServerRouteDestination destination = new NettyRestServerRouteDestination(name, restResource);
                this.configurationBuilder.routing().add(new Route((RouteSource)source, (RouteDestination)destination));
            });
            this.router = new MultiTenantRouter(this.configurationBuilder.build());
            this.router.start();
            EndpointLogger.ROOT_LOGGER.routerStarted(NetworkUtils.formatAddress((InetSocketAddress)hotrodAddress), NetworkUtils.formatAddress((InetSocketAddress)restAddress));
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.failedStart(e, this.name);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.router != null) {
            this.router.stop();
        }
    }

    public synchronized MultiTenantRouter getValue() throws IllegalStateException {
        if (this.router == null) {
            throw EndpointLogger.ROOT_LOGGER.serviceNotStarted();
        }
        return this.router;
    }

    InjectedValue<SocketBinding> getHotrodSocketBinding() {
        return this.hotrodSocketBinding;
    }

    HotRodRouting getHotRodRouting(String sniHostName) {
        return this.hotrodRouting.computeIfAbsent(sniHostName, v -> new HotRodRouting());
    }

    InjectedValue<SocketBinding> getRestSocketBinding() {
        return this.restSocketBinding;
    }

    RestRouting getRestRouting(String path, String name) {
        return this.restRouting.computeIfAbsent(path, v -> new RestRouting(name));
    }

    public void tcpNoDelay(boolean tcpNoDelay) {
        this.configurationBuilder.hotrod().tcpNoDelay(tcpNoDelay);
    }

    public void keepAlive(boolean keepAlive) {
        this.configurationBuilder.hotrod().keepAlive(keepAlive);
    }

    public void sendBufferSize(int sendBufferSize) {
        this.configurationBuilder.hotrod().sendBufferSize(sendBufferSize);
    }

    public void receiveBufferSize(int receiveBufferSize) {
        this.configurationBuilder.hotrod().receiveBufferSize(receiveBufferSize);
    }

    static class RestRouting {
        private final InjectedValue<NettyRestServer> rest = new InjectedValue();
        private final String name;

        public RestRouting(String name) {
            this.name = name;
        }

        public InjectedValue<NettyRestServer> getRest() {
            return this.rest;
        }

        public String getName() {
            return this.name;
        }
    }

    static class HotRodRouting {
        private final InjectedValue<HotRodServer> hotRod = new InjectedValue();
        private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();

        HotRodRouting() {
        }

        public InjectedValue<HotRodServer> getHotRod() {
            return this.hotRod;
        }

        public InjectedValue<SecurityRealm> getSecurityRealm() {
            return this.securityRealm;
        }
    }
}

