/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.ChecksumType;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.TableFormatConfig;

public class BlockBasedTableConfig
extends TableFormatConfig {
    private boolean cacheIndexAndFilterBlocks_ = false;
    private boolean pinL0FilterAndIndexBlocksInCache_ = false;
    private IndexType indexType_;
    private boolean hashIndexAllowCollision_ = true;
    private ChecksumType checksumType_ = ChecksumType.kCRC32c;
    private boolean noBlockCache_ = false;
    private long blockSize_ = 4096L;
    private long blockCacheSize_ = 0x800000L;
    private int blockCacheNumShardBits_ = 0;
    private long blockCacheCompressedSize_ = 0L;
    private int blockCacheCompressedNumShardBits_ = 0;
    private int blockSizeDeviation_ = 10;
    private int blockRestartInterval_ = 16;
    private Filter filter_ = null;
    private boolean wholeKeyFiltering_ = true;
    private int formatVersion_ = 0;

    public BlockBasedTableConfig() {
        this.indexType_ = IndexType.kBinarySearch;
    }

    public BlockBasedTableConfig setNoBlockCache(boolean bl) {
        this.noBlockCache_ = bl;
        return this;
    }

    public boolean noBlockCache() {
        return this.noBlockCache_;
    }

    public BlockBasedTableConfig setBlockCacheSize(long l) {
        this.blockCacheSize_ = l;
        return this;
    }

    public long blockCacheSize() {
        return this.blockCacheSize_;
    }

    public BlockBasedTableConfig setCacheNumShardBits(int n) {
        this.blockCacheNumShardBits_ = n;
        return this;
    }

    public int cacheNumShardBits() {
        return this.blockCacheNumShardBits_;
    }

    public BlockBasedTableConfig setBlockSize(long l) {
        this.blockSize_ = l;
        return this;
    }

    public long blockSize() {
        return this.blockSize_;
    }

    public BlockBasedTableConfig setBlockSizeDeviation(int n) {
        this.blockSizeDeviation_ = n;
        return this;
    }

    public int blockSizeDeviation() {
        return this.blockSizeDeviation_;
    }

    public BlockBasedTableConfig setBlockRestartInterval(int n) {
        this.blockRestartInterval_ = n;
        return this;
    }

    public int blockRestartInterval() {
        return this.blockRestartInterval_;
    }

    public BlockBasedTableConfig setWholeKeyFiltering(boolean bl) {
        this.wholeKeyFiltering_ = bl;
        return this;
    }

    public boolean wholeKeyFiltering() {
        return this.wholeKeyFiltering_;
    }

    public BlockBasedTableConfig setFilter(Filter filter) {
        this.filter_ = filter;
        return this;
    }

    public boolean cacheIndexAndFilterBlocks() {
        return this.cacheIndexAndFilterBlocks_;
    }

    public BlockBasedTableConfig setCacheIndexAndFilterBlocks(boolean bl) {
        this.cacheIndexAndFilterBlocks_ = bl;
        return this;
    }

    public boolean pinL0FilterAndIndexBlocksInCache() {
        return this.pinL0FilterAndIndexBlocksInCache_;
    }

    public BlockBasedTableConfig setPinL0FilterAndIndexBlocksInCache(boolean bl) {
        this.pinL0FilterAndIndexBlocksInCache_ = bl;
        return this;
    }

    public boolean hashIndexAllowCollision() {
        return this.hashIndexAllowCollision_;
    }

    public BlockBasedTableConfig setHashIndexAllowCollision(boolean bl) {
        this.hashIndexAllowCollision_ = bl;
        return this;
    }

    public long blockCacheCompressedSize() {
        return this.blockCacheCompressedSize_;
    }

    public BlockBasedTableConfig setBlockCacheCompressedSize(long l) {
        this.blockCacheCompressedSize_ = l;
        return this;
    }

    public int blockCacheCompressedNumShardBits() {
        return this.blockCacheCompressedNumShardBits_;
    }

    public BlockBasedTableConfig setBlockCacheCompressedNumShardBits(int n) {
        this.blockCacheCompressedNumShardBits_ = n;
        return this;
    }

    public BlockBasedTableConfig setChecksumType(ChecksumType checksumType) {
        this.checksumType_ = checksumType;
        return this;
    }

    public ChecksumType checksumType() {
        return this.checksumType_;
    }

    public BlockBasedTableConfig setIndexType(IndexType indexType) {
        this.indexType_ = indexType;
        return this;
    }

    public IndexType indexType() {
        return this.indexType_;
    }

    public BlockBasedTableConfig setFormatVersion(int n) {
        assert (n >= 0 && n <= 2);
        this.formatVersion_ = n;
        return this;
    }

    public int formatVersion() {
        return this.formatVersion_;
    }

    @Override
    protected long newTableFactoryHandle() {
        long l = 0L;
        if (this.filter_ != null) {
            l = this.filter_.nativeHandle_;
        }
        return this.newTableFactoryHandle(this.noBlockCache_, this.blockCacheSize_, this.blockCacheNumShardBits_, this.blockSize_, this.blockSizeDeviation_, this.blockRestartInterval_, this.wholeKeyFiltering_, l, this.cacheIndexAndFilterBlocks_, this.pinL0FilterAndIndexBlocksInCache_, this.hashIndexAllowCollision_, this.blockCacheCompressedSize_, this.blockCacheCompressedNumShardBits_, this.checksumType_.getValue(), this.indexType_.getValue(), this.formatVersion_);
    }

    private native long newTableFactoryHandle(boolean var1, long var2, int var4, long var5, int var7, int var8, boolean var9, long var10, boolean var12, boolean var13, boolean var14, long var15, int var17, byte var18, byte var19, int var20);
}

