/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import javax.ws.rs.core.SecurityContext;
import org.infinispan.rest.embedded.netty4.NettySecurityContext;
import org.infinispan.rest.embedded.netty4.security.Authenticator;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RequestDispatcher {
    protected final SynchronousDispatcher dispatcher;
    protected final ResteasyProviderFactory providerFactory;
    private final Authenticator authenticator;

    public RequestDispatcher(SynchronousDispatcher dispatcher, ResteasyProviderFactory providerFactory, Authenticator authenticator) {
        this.dispatcher = dispatcher;
        this.providerFactory = providerFactory;
        this.authenticator = authenticator;
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, boolean handleNotFound) throws IOException {
        try {
            NettySecurityContext securityContext;
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.providerFactory);
            }
            if (this.authenticator != null) {
                securityContext = this.authenticator.authenticate(ctx, request, response);
                if (securityContext == null) {
                    return;
                }
            } else {
                securityContext = NettySecurityContext.ANONYMOUS;
            }
            try {
                ResteasyProviderFactory.pushContext(SecurityContext.class, (Object)securityContext);
                ResteasyProviderFactory.pushContext(ChannelHandlerContext.class, (Object)ctx);
                if (handleNotFound) {
                    this.dispatcher.invoke(request, response);
                } else {
                    this.dispatcher.invokePropagateNotFound(request, response);
                }
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }
}

