/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;

public class DefaultCompleter
implements CommandLineCompleter {
    private final CandidatesProvider candidatesProvider;

    public DefaultCompleter(CandidatesProvider candidatesProvider) {
        if (candidatesProvider == null) {
            throw new IllegalArgumentException("candidatesProvider can't be null.");
        }
        this.candidatesProvider = candidatesProvider;
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int nextCharIndex;
        for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
        }
        Collection<String> all = this.candidatesProvider.getAllCandidates(ctx);
        if (all.isEmpty()) {
            return -1;
        }
        String opBuffer = buffer.substring(nextCharIndex).trim();
        if (opBuffer.isEmpty()) {
            candidates.addAll(all);
        } else {
            for (String name : all) {
                if (!name.startsWith(opBuffer)) continue;
                candidates.add(name);
            }
            Collections.sort(candidates);
        }
        return nextCharIndex;
    }

    public static interface CandidatesProvider {
        public Collection<String> getAllCandidates(CommandContext var1);
    }
}

