/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class QueueService
implements Service<Void> {
    private final InjectedValue<ActiveMQServer> activeMQServer = new InjectedValue();
    private final CoreQueueConfiguration queueConfiguration;
    private final boolean temporary;

    public QueueService(CoreQueueConfiguration queueConfiguration, boolean temporary) {
        if (queueConfiguration == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("queueConfiguration");
        }
        this.queueConfiguration = queueConfiguration;
        this.temporary = temporary;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            ActiveMQServer server = (ActiveMQServer)this.activeMQServer.getValue();
            server.deployQueue(new SimpleString(this.queueConfiguration.getAddress()), new SimpleString(this.queueConfiguration.getName()), SimpleString.toSimpleString((String)this.queueConfiguration.getFilterString()), this.queueConfiguration.isDurable(), this.temporary);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            ActiveMQServer server = (ActiveMQServer)this.activeMQServer.getValue();
            server.destroyQueue(new SimpleString(this.queueConfiguration.getName()), null, false);
        }
        catch (Exception e) {
            MessagingLogger.ROOT_LOGGER.failedToDestroy("queue", this.queueConfiguration.getName());
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<ActiveMQServer> getActiveMQServer() {
        return this.activeMQServer;
    }
}

