/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.logging;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordValidationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;

public class DomainManagementLogger_$logger
extends DelegatingBasicLogger
implements DomainManagementLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DomainManagementLogger_$logger.class.getName();
    private static final String userAndPasswordWarning = "WFLYDM0001: Properties file defined with default user and password, this will be easy to guess.";
    private static final String whitespaceTrimmed = "WFLYDM0002: Whitespace has been trimmed from the Base64 representation of the secret identity.";
    private static final String passwordAttributeDeprecated = "WFLYDM0003: The attribute 'password' is deprecated, 'keystore-password' should be used instead.";
    private static final String realmMisMatch = "WFLYDM0004: The realm name of the defined security realm '%s' does not match the realm name within the properties file '%s'.";
    private static final String failedRetrieveLdapGroups = "WFLYDM0005: Failed to retrieving groups from the LDAP provider.";
    private static final String failedRetrieveMatchingLdapGroups = "WFLYDM0006: Failed to retrieving matching groups from the pattern, check the regular expression for pattern attribute.";
    private static final String failedRetrieveMatchingGroups = "WFLYDM0007: Failed to retrieve matching groups from the groups, check the regular expression for groups attribute.";
    private static final String failedRetrieveLdapAttribute = "WFLYDM0008: Failed to retrieve attribute %s from search result.";
    private static final String cannotPerformVerification = "WFLYDM0009: Unable to perform verification";
    private static final String invalidRealm = "WFLYDM0010: Invalid Realm '%s' expected '%s'";
    private static final String nameNotFound = "WFLYDM0011: Can't follow referral for authentication: %s";
    private static final String noUsername = "WFLYDM0013: No username provided.";
    private static final String noPassword = "WFLYDM0014: No password to verify.";
    private static final String oneOfRequired = "WFLYDM0015: One of '%s' or '%s' required.";
    private static final String realmNotSupported = "WFLYDM0016: Realm choice not currently supported.";
    private static final String unableToLoadProperties = "WFLYDM0017: Unable to load properties";
    private static final String unableToStart = "WFLYDM0018: Unable to start service";
    private static final String userNotFound = "WFLYDM0019: User '%s' not found.";
    private static final String userNotFoundInDirectory = "WFLYDM0020: User '%s' not found in directory.";
    private static final String noConsoleAvailable = "WFLYDM0021: No java.io.Console available to interact with user.";
    private static final String propertiesFileNotFound = "WFLYDM0023: No %s files found.";
    private static final String enterNewUserDetails = "Enter the details of the new user to add.";
    private static final String realmPrompt = "Realm (%s)";
    private static final String usernamePrompt0 = "Username";
    private static final String usernamePrompt1 = "Username (%s)";
    private static final String noUsernameExiting = "WFLYDM0024: No Username entered, exiting.";
    private static final String passwordPrompt = "Password";
    private static final String noPasswordExiting = "WFLYDM0025: No Password entered, exiting.";
    private static final String passwordConfirmationPrompt = "Re-enter Password";
    private static final String passwordMisMatch = "WFLYDM0026: The passwords do not match.";
    private static final String usernameNotAlphaNumeric = "WFLYDM0028: Username must be alphanumeric with the exception of the following accepted symbols (%s)";
    private static final String aboutToAddUser = "About to add user '%s' for realm '%s'";
    private static final String isCorrectPrompt = "Is this correct";
    private static final String usernameEasyToGuess = "The username '%s' is easy to guess";
    private static final String sureToAddUser = "Are you sure you want to add user '%s' yes/no?";
    private static final String invalidConfirmationResponse = "WFLYDM0029: Invalid response. (Valid responses are %s and %s)";
    private static final String addedUser = "Added user '%s' to file '%s'";
    private static final String unableToAddUser = "WFLYDM0030: Unable to add user to %s due to error %s";
    private static final String unableToLoadUsers = "WFLYDM0031: Unable to add load users from %s due to error %s";
    private static final String errorHeader = "Error";
    private static final String serverUser = "Is this new user going to be used for one AS process to connect to another AS process? %ne.g. for a slave host controller connecting to the master or for a Remoting connection for server to server EJB calls.";
    private static final String yesNo = "yes/no?";
    private static final String secretElement = "To represent the user add the following to the server-identities definition <secret value=\"%s\" />";
    private static final String multipleAuthenticationMechanismsDefined = "WFLYDM0033: Configuration for security realm '%s' includes multiple username/password based authentication mechanisms (%s). Only one is allowed";
    private static final String operationFailedOneOfRequired = "WFLYDM0034: One of '%s' or '%s' required.";
    private static final String operationFailedOnlyOneOfRequired = "WFLYDM0035: Only one of '%s' or '%s' is required.";
    private static final String canNotBeNull = "WFLYDM0036: '%s' can not be null.";
    private static final String noSecurityContextEstablished = "WFLYDM0037: No security context has been established.";
    private static final String filePrompt = "What type of user do you wish to add? %n a) Management User (mgmt-users.properties) %n b) Application User (application-users.properties)";
    private static final String groupsPrompt = "What groups do you want this user to belong to? (Please enter a comma separated list, or leave blank for none)";
    private static final String addedGroups = "Added user '%s' with groups %s to file '%s'";
    private static final String invalidChoiceResponse = "WFLYDM0039: Invalid response. (Valid responses are A, a, B, or b)";
    private static final String aboutToUpdateEnabledUser = "User '%s' already exists and is enabled, would you like to... %n a) Update the existing user password and roles %n b) Disable the existing user %n c) Type a new username";
    private static final String aboutToUpdateDisabledUser = "User '%s' already exists and is disabled, would you like to... %n a) Update the existing user password and roles %n b) Enable the existing user %n c) Type a new username";
    private static final String updateUser = "Updated user '%s' to file '%s'";
    private static final String unableToUpdateUser = "WFLYDM0040: Unable to update user to %s due to error %s";
    private static final String updatedGroups = "Updated user '%s' with groups %s to file '%s'";
    private static final String invalidLocalUser = "WFLYDM0041: The user '%s' is not allowed in a local authentication.";
    private static final String multipleCallbackHandlerForMechanism = "WFLYDM0042: Multiple CallbackHandlerServices for the same mechanism (%s)";
    private static final String noCallbackHandlerForMechanism = "WFLYDM0043: No CallbackHandler available for mechanism %s in realm %s";
    private static final String noPlugInProvidersLoaded = "WFLYDM0044: No plug in providers found for module name %s";
    private static final String unableToLoadPlugInProviders = "WFLYDM0045: Unable to load plug-in for module %s due to error (%s)";
    private static final String noAuthenticationPlugInFound = "WFLYDM0046: No authentication plug-in found for name %s";
    private static final String unableToInitialisePlugIn = "WFLYDM0047: Unable to initialise plug-in %s due to error %s";
    private static final String passwordNotStrongEnough = "WFLYDM0048: Password is not strong enough, it is '%s'. It should be at least '%s'.";
    private static final String passwordMustNotBeEqual = "WFLYDM0049: Password must not be equal to '%s', this value is restricted.";
    private static final String passwordMustHaveDigit = "WFLYDM0050: Password must have at least %d digit.";
    private static final String passwordMustHaveSymbol = "WFLYDM0051: Password must have at least %s non-alphanumeric symbol.";
    private static final String passwordMustHaveAlpha = "WFLYDM0052: Password must have at least %d alphanumeric character.";
    private static final String passwordNotLongEnough = "WFLYDM0053: Password must have at least %s characters!";
    private static final String unableToLoadKeyTrustFile = "WFLYDM0054: Unable to load key trust file.";
    private static final String unableToOperateOnTrustStore = "WFLYDM0055: Unable to operate on trust store.";
    private static final String unableToCreateDelegateTrustManager = "WFLYDM0056: Unable to create delegate trust manager.";
    private static final String onlyOneSyslogHandlerProtocol = "WFLYDM0057: The syslog-handler can only contain one protocol %s";
    private static final String noHandlerCalled = "WFLYDM0058: There is no handler called '%s'";
    private static final String sysLogProtocolAlreadyConfigured = "WFLYDM0059: There is already a protocol configured for the syslog handler at %s";
    private static final String noSyslogProtocol = "WFLYDM0060: No syslog protocol was given";
    private static final String noFormatterCalled = "WFLYDM0061: There is no formatter called '%s'";
    private static final String cannotRemoveReferencedFormatter = "WFLYDM0062: Can not remove formatter, it is still referenced by the handler '%s'";
    private static final String handlerAlreadyExists = "WFLYDM0063: Handler names must be unique. There is already a handler called '%s' at %s";
    private static final String multipleRealmsDetected = "WFLYDM0064: Different realm names detected '%s', '%s' reading user property files, all realms must be equal.";
    private static final String userRealmNotMatchDiscovered = "WFLYDM0065: The user supplied realm name '%s' does not match the realm name discovered from the property file(s) '%s'.";
    private static final String groupPropertiesButNoUserProperties = "WFLYDM0066: A group properties file '%s' has been specified, however no user properties has been specified.";
    private static final String realmMustBeSpecified = "WFLYDM0067: A realm name must be specified.";
    private static final String inconsistentRbacConfiguration = "WFLYDM0068: The current operation(s) would result in role based access control being enabled but leave it impossible for authenticated users to be assigned roles.";
    private static final String inconsistentRbacRuntimeState = "WFLYDM0069: The runtime role mapping configuration is inconsistent, the server must be restarted.";
    private static final String invalidChoiceUpdateUserResponse = "WFLYDM0070: Invalid response. (Valid responses are A, a, B, b, C or c)";
    private static final String duplicateIncludeExclude = "WFLYDM0071: Role '%s' already contains an %s for type=%s, name=%s, realm=%s.";
    private static final String multipleAuthorizationConfigurationsDefined = "WFLYDM0072: Configuration for security realm '%s' includes multiple authorization configurations (%s). Only one is allowed";
    private static final String multipleUsernameToDnConfigurationsDefined = "WFLYDM0073: Configuration for security realm '%s' includes multiple username-to-dn resources within the authorization=ldap resource (%s). Only one is allowed";
    private static final String noGroupSearchDefined = "WFLYDM0074: Configuration for security realm '%s' does not contain any group-search resource within the authorization=ldap resource.";
    private static final String multipleGroupSearchConfigurationsDefined = "WFLYDM0075: Configuration for security realm '%s' includes multiple group-search resources within the authorization=ldap resource (%s). Only one is allowed";
    private static final String invalidRoleName = "WFLYDM0076: The role name '%s' is not a valid standard role.";
    private static final String invalidRoleNameDomain = "WFLYDM0077: The role name '%s' is not a valid standard role and is not a host scoped role or a server group scoped role.";
    private static final String roleMappingRemaining = "WFLYDM0078: The scoped role '%s' can not be removed as a role mapping still exists.";
    private static final String duplicateScopedRole = "WFLYDM0079: A %s already exists with name '%s'";
    private static final String scopedRoleStandardName = "WFLYDM0080: The name '%s' conflicts with the standard role name of '%s' - comparison is case insensitive.";
    private static final String badBaseRole = "WFLYDM0081: The base-role '%s' is not one of the standard roles for the current authorization provider.";
    private static final String passwordUsernameMatchError = "WFLYDM0082: The password must be different from the username";
    private static final String noKey = "WFLYDM0083: The KeyStore %s does not contain any keys.";
    private static final String aliasNotKey = "WFLYDM0084: The alias specified '%s' is not a Key, valid aliases are %s";
    private static final String aliasNotFound = "WFLYDM0085: The alias specified '%s' does not exist in the KeyStore, valid aliases are %s";
    private static final String keyStoreNotFound = "WFLYDM0086: The KeyStore can not be found at %s";
    private static final String multipleCacheConfigurationsDefined = "WFLYDM0087: Configuration for security realm '%s' includes multiple cache definitions at the same position in the hierarchy. Only one is allowed";
    private static final String usernameNotLoaded = "WFLYDM0088: Unable to load username for supplied username '%s'";
    private static final String noNonProgressingOperationFound = "WFLYDM0089: No operation was found that has been holding the operation execution write lock for long than [%d] seconds";
    private static final String invalidKeytab = "WFLYDM0090: Invalid Keytab path";
    private static final String subjectIdentityLoggedOut = "WFLYDM0091: logout has already been called on this SubjectIdentity.";
    private static final String unableToObtainTGT = "WFLYDM0092: Unable to obtain Kerberos TGT";
    private static final String keytabLoginFailed = "WFLYDM0093: Login failed using Keytab for principal '%s' to handle request for host '%s'";
    private static final String kerberosWithoutKeytab = "WFLYDM0094: Kerberos is enabled for authentication on security realm '%s' but no Keytab has been added to the server-identity.";
    private static final String noCipherSuitesInCommon = "WFLYDM0095: No cipher suites in common, supported=(%s), requested=(%s)";
    private static final String noProtocolsInCommon = "WFLYDM0096: No protocols in common, supported=(%s), requested=(%s)";
    private static final String passwordShouldNotBeEqual = "WFLYDM0097: Password should not be equal to '%s', this value is restricted.";
    private static final String passwordUsernameShouldNotMatch = "WFLYDM0098: The password should be different from the username";
    private static final String passwordShouldHaveXCharacters = "WFLYDM0099: Password should have at least %s characters!";
    private static final String passwordShouldHaveAlpha = "WFLYDM0100: Password should have at least %d alphanumeric character.";
    private static final String passwordShouldHaveDigit = "WFLYDM0101: Password should have at least %d digit.";
    private static final String passwordShouldHaveSymbol = "WFLYDM0102: Password should have at least %s non-alphanumeric symbol.";
    private static final String invalidSize = "WFLYDM0103: Invalid size %s";
    private static final String suffixContainsMillis = "WFLYDM0104: The suffix (%s) can not contain seconds or milliseconds.";
    private static final String invalidSuffix = "WFLYDM0105: The suffix (%s) is invalid. A suffix must be a valid date format.";
    private static final String filePermissionsProblemsFound = "WFLYDM0106: File permissions problems found while attempting to update %s file.";
    private static final String domainRolloutNotProgressing = "WFLYDM0107: Operation '%s' has been holding the operation execution write lock for longer than [%d] seconds, but it is part of the rollout of a domain-wide operation with domain-uuid '%s' that has other operations that are alsonot progressing. Their ids are: %s. Cancellation of the operation on the master host controller is recommended.";
    private static final String unsupportedResource = "WFLYDM0108: Unsupported resource '%s'";
    private static final String keyTabFileNotFound = "WFLYDM0109: The Keytab file '%s' does not exist.";
    private static final String unableToLoadSimpleNameForGroup = "WFLYDM0110: Unable to load a simple name for group '%s'";
    private static final String keystoreWillBeCreated = "WFLYDM0111: Keystore %s not found, it will be auto generated on first use with a self signed certificate for host %s";
    private static final String failedToGenerateSelfSignedCertificate = "WFLYDM0112: Failed to generate self signed certificate";
    private static final String keystoreHasBeenCreated = "WFLYDM0113: Generated self signed certificate at %s. Please note that self signed certificates are not secure, and should only be used for testing purposes. Do not use this self signed certificate in production.\nSHA-1 fingerprint of the generated key is %s\nSHA-256 fingerprint of the generated key is %s";
    private static final String failedToCreateLazyInitSSLContext = "WFLYDM0114: Failed to lazily initialize SSL context";
    private static final String noSignatureAlgorithmNameGiven = "WFLYDM0115: No signature algorithm name given";
    private static final String unknownSignatureAlgorithmName = "WFLYDM0116: Signature algorithm name \"%s\" is not recognized";
    private static final String noSigningKeyGiven = "WFLYDM0117: No signing key given";
    private static final String signingKeyNotCompatWithSig = "WFLYDM0118: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    private static final String validAfterBeforeValidBefore = "WFLYDM0119: Not-valid-before date of %s is after not-valid-after date of %s";
    private static final String noIssuerDnGiven = "WFLYDM0120: No issuer DN given";
    private static final String noPublicKeyGiven = "WFLYDM0121: No public key given";
    private static final String uniqueIdNotAllowed = "WFLYDM0122: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    private static final String invalidKeyForCert = "WFLYDM0123: X.509 encoding of public key with algorithm \"%s\" failed";
    private static final String certSigningFailed = "WFLYDM0124: Failed to sign certificate";
    private static final String serialNumberTooSmall = "WFLYDM0125: Certificate serial number must be positive";
    private static final String serialNumberTooLarge = "WFLYDM0126: Certificate serial number too large (cannot exceed 20 octets)";
    private static final String noSequenceToEnd = "WFLYDM0127: No sequence to end";
    private static final String noSetToEnd = "WFLYDM0128: No set to end";
    private static final String noExplicitlyTaggedElementToEnd = "WFLYDM0129: No explicitly tagged element to end";
    private static final String asnInvalidOidCharacter = "WFLYDM0130: Invalid OID character";
    private static final String asnOidMustHaveAtLeast2Components = "WFLYDM0131: OID must have at least 2 components";
    private static final String asnInvalidValueForFirstOidComponent = "WFLYDM0132: Invalid value for first OID component; expected 0, 1, or 2";
    private static final String asnInvalidValueForSecondOidComponent = "WFLYDM0133: Invalid value for second OID component; expected a value between 0 and 39 (inclusive)";
    private static final String asnInvalidLength = "WFLYDM0134: Invalid length";
    private static final String passwordUsernameMustMatchInfo = "The password must be different from the username";
    private static final String passwordUsernameShouldMatchInfo = "The password should be different from the username";
    private static final String passwordMustNotEqualInfo = "The password must not be one of the following restricted values {%s}";
    private static final String passwordShouldNotEqualInfo = "The password should not be one of the following restricted values {%s}";
    private static final String passwordLengthInfo = "%s characters";
    private static final String passwordMustHaveAlphaInfo = "%d alphabetic character(s)";
    private static final String passwordMustHaveDigitInfo = "%d digit(s)";
    private static final String passwordMustHaveSymbolInfo = "%s non-alphanumeric symbol(s)";
    private static final String passwordMustContainInfo = "The password must contain at least %s";
    private static final String passwordShouldContainInfo = "The password should contain at least %s";
    private static final String sureToSetPassword = "Are you sure you want to use the password entered yes/no?";
    private static final String argUsage = "Usage: ./add-user.sh [args...]%nwhere args include:";
    private static final String argApplicationUsers = "If set add an application user instead of a management user";
    private static final String argDomainConfigDirUsers = "Define the location of the domain config directory.";
    private static final String argServerConfigDirUsers = "Define the location of the server config directory.";
    private static final String argUserProperties = "The file name of the user properties file which can be an absolute path.";
    private static final String argGroupProperties = "The file name of the group properties file which can be an absolute path. (If group properties is specified then user properties MUST also be specified).";
    private static final String argPassword = "Password of the user, this will be checked against the password requirements defined within the add-user.properties configuration";
    private static final String argUser = "Name of the user";
    private static final String argRealm = "Name of the realm used to secure the management interfaces (default is \"ManagementRealm\")";
    private static final String argSilent = "Activate the silent mode (no output to the console)";
    private static final String argRole = "Comma-separated list of roles for the user.";
    private static final String argGroup = "Comma-separated list of groups for the user.";
    private static final String argEnable = "Enable the user";
    private static final String argDisable = "Disable the user";
    private static final String argConfirmWarning = "Automatically confirm warning in interactive mode";
    private static final String argHelp = "Display this message and exit";
    private static final String yes = "yes";
    private static final String shortYes = "y";
    private static final String no = "no";
    private static final String shortNo = "n";
    private static final String alternativeRealm = "The realm name supplied must match the name used by the server configuration which by default would be '%s'";
    private static final String realmConfirmation = "Are you sure you want to set the realm to '%s'";
    private static final String passwordRequirements = "Password requirements are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    private static final String passwordRecommendations = "Password recommendations are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    private static final String userSuppliedRealm = "Using realm '%s' as specified on the command line.";
    private static final String discoveredRealm = "Using realm '%s' as discovered from the existing property files.";

    public DomainManagementLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void userAndPasswordWarning() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.userAndPasswordWarning$str(), new Object[0]);
    }

    protected String userAndPasswordWarning$str() {
        return userAndPasswordWarning;
    }

    @Override
    public final void whitespaceTrimmed() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.whitespaceTrimmed$str(), new Object[0]);
    }

    protected String whitespaceTrimmed$str() {
        return whitespaceTrimmed;
    }

    @Override
    public final void passwordAttributeDeprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.passwordAttributeDeprecated$str(), new Object[0]);
    }

    protected String passwordAttributeDeprecated$str() {
        return passwordAttributeDeprecated;
    }

    @Override
    public final void realmMisMatch(String realmRealmName, String fileRealmName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.realmMisMatch$str(), (Object)realmRealmName, (Object)fileRealmName);
    }

    protected String realmMisMatch$str() {
        return realmMisMatch;
    }

    @Override
    public final void failedRetrieveLdapGroups(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedRetrieveLdapGroups$str(), new Object[0]);
    }

    protected String failedRetrieveLdapGroups$str() {
        return failedRetrieveLdapGroups;
    }

    @Override
    public final void failedRetrieveMatchingLdapGroups(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedRetrieveMatchingLdapGroups$str(), new Object[0]);
    }

    protected String failedRetrieveMatchingLdapGroups$str() {
        return failedRetrieveMatchingLdapGroups;
    }

    @Override
    public final void failedRetrieveMatchingGroups() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedRetrieveMatchingGroups$str(), new Object[0]);
    }

    protected String failedRetrieveMatchingGroups$str() {
        return failedRetrieveMatchingGroups;
    }

    @Override
    public final void failedRetrieveLdapAttribute(String attribute) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedRetrieveLdapAttribute$str(), (Object)attribute);
    }

    protected String failedRetrieveLdapAttribute$str() {
        return failedRetrieveLdapAttribute;
    }

    protected String cannotPerformVerification$str() {
        return cannotPerformVerification;
    }

    @Override
    public final IOException cannotPerformVerification(Throwable cause) {
        IOException result = new IOException(String.format(this.cannotPerformVerification$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRealm$str() {
        return invalidRealm;
    }

    @Override
    public final IllegalStateException invalidRealm(String realm, String expectedRealm) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidRealm$str(), realm, expectedRealm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameNotFound$str() {
        return nameNotFound;
    }

    @Override
    public final NamingException nameNotFound(String name) {
        NamingException result = new NamingException(String.format(this.nameNotFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noUsername$str() {
        return noUsername;
    }

    @Override
    public final IOException noUsername() {
        IOException result = new IOException(String.format(this.noUsername$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPassword$str() {
        return noPassword;
    }

    @Override
    public final IOException noPassword() {
        IOException result = new IOException(String.format(this.noPassword$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String oneOfRequired$str() {
        return oneOfRequired;
    }

    @Override
    public final IllegalArgumentException oneOfRequired(String attr1, String attr2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.oneOfRequired$str(), attr1, attr2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmNotSupported$str() {
        return realmNotSupported;
    }

    @Override
    public final UnsupportedCallbackException realmNotSupported(Callback callback) {
        UnsupportedCallbackException result = new UnsupportedCallbackException(callback, String.format(this.realmNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadProperties$str() {
        return unableToLoadProperties;
    }

    @Override
    public final StartException unableToLoadProperties(Throwable cause) {
        StartException result = new StartException(String.format(this.unableToLoadProperties$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStart$str() {
        return unableToStart;
    }

    @Override
    public final StartException unableToStart(Throwable cause) {
        StartException result = new StartException(String.format(this.unableToStart$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userNotFound$str() {
        return userNotFound;
    }

    @Override
    public final String userNotFound(String username) {
        return String.format(this.userNotFound$str(), username);
    }

    protected String userNotFoundInDirectory$str() {
        return userNotFoundInDirectory;
    }

    @Override
    public final NamingException userNotFoundInDirectory(String username) {
        NamingException result = new NamingException(String.format(this.userNotFoundInDirectory$str(), username));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noConsoleAvailable$str() {
        return noConsoleAvailable;
    }

    @Override
    public final IllegalStateException noConsoleAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.noConsoleAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertiesFileNotFound$str() {
        return propertiesFileNotFound;
    }

    @Override
    public final String propertiesFileNotFound(String file) {
        return String.format(this.propertiesFileNotFound$str(), file);
    }

    protected String enterNewUserDetails$str() {
        return enterNewUserDetails;
    }

    @Override
    public final String enterNewUserDetails() {
        return String.format(this.enterNewUserDetails$str(), new Object[0]);
    }

    protected String realmPrompt$str() {
        return realmPrompt;
    }

    @Override
    public final String realmPrompt(String realm) {
        return String.format(this.realmPrompt$str(), realm);
    }

    protected String usernamePrompt0$str() {
        return usernamePrompt0;
    }

    @Override
    public final String usernamePrompt() {
        return String.format(this.usernamePrompt0$str(), new Object[0]);
    }

    protected String usernamePrompt1$str() {
        return usernamePrompt1;
    }

    @Override
    public final String usernamePrompt(String defaultUsername) {
        return String.format(this.usernamePrompt1$str(), defaultUsername);
    }

    protected String noUsernameExiting$str() {
        return noUsernameExiting;
    }

    @Override
    public final String noUsernameExiting() {
        return String.format(this.noUsernameExiting$str(), new Object[0]);
    }

    protected String passwordPrompt$str() {
        return passwordPrompt;
    }

    @Override
    public final String passwordPrompt() {
        return String.format(this.passwordPrompt$str(), new Object[0]);
    }

    protected String noPasswordExiting$str() {
        return noPasswordExiting;
    }

    @Override
    public final String noPasswordExiting() {
        return String.format(this.noPasswordExiting$str(), new Object[0]);
    }

    protected String passwordConfirmationPrompt$str() {
        return passwordConfirmationPrompt;
    }

    @Override
    public final String passwordConfirmationPrompt() {
        return String.format(this.passwordConfirmationPrompt$str(), new Object[0]);
    }

    protected String passwordMisMatch$str() {
        return passwordMisMatch;
    }

    @Override
    public final String passwordMisMatch() {
        return String.format(this.passwordMisMatch$str(), new Object[0]);
    }

    protected String usernameNotAlphaNumeric$str() {
        return usernameNotAlphaNumeric;
    }

    @Override
    public final String usernameNotAlphaNumeric(String symbols) {
        return String.format(this.usernameNotAlphaNumeric$str(), symbols);
    }

    protected String aboutToAddUser$str() {
        return aboutToAddUser;
    }

    @Override
    public final String aboutToAddUser(String username, String realm) {
        return String.format(this.aboutToAddUser$str(), username, realm);
    }

    protected String isCorrectPrompt$str() {
        return isCorrectPrompt;
    }

    @Override
    public final String isCorrectPrompt() {
        return String.format(this.isCorrectPrompt$str(), new Object[0]);
    }

    protected String usernameEasyToGuess$str() {
        return usernameEasyToGuess;
    }

    @Override
    public final String usernameEasyToGuess(String username) {
        return String.format(this.usernameEasyToGuess$str(), username);
    }

    protected String sureToAddUser$str() {
        return sureToAddUser;
    }

    @Override
    public final String sureToAddUser(String username) {
        return String.format(this.sureToAddUser$str(), username);
    }

    protected String invalidConfirmationResponse$str() {
        return invalidConfirmationResponse;
    }

    @Override
    public final String invalidConfirmationResponse(String firstValues, String secondValues) {
        return String.format(this.invalidConfirmationResponse$str(), firstValues, secondValues);
    }

    protected String addedUser$str() {
        return addedUser;
    }

    @Override
    public final String addedUser(String username, String fileName) {
        return String.format(this.addedUser$str(), username, fileName);
    }

    protected String unableToAddUser$str() {
        return unableToAddUser;
    }

    @Override
    public final String unableToAddUser(String file, String error) {
        return String.format(this.unableToAddUser$str(), file, error);
    }

    protected String unableToLoadUsers$str() {
        return unableToLoadUsers;
    }

    @Override
    public final String unableToLoadUsers(String file, String error) {
        return String.format(this.unableToLoadUsers$str(), file, error);
    }

    protected String errorHeader$str() {
        return errorHeader;
    }

    @Override
    public final String errorHeader() {
        return String.format(this.errorHeader$str(), new Object[0]);
    }

    protected String serverUser$str() {
        return serverUser;
    }

    @Override
    public final String serverUser() {
        return String.format(this.serverUser$str(), new Object[0]);
    }

    protected String yesNo$str() {
        return yesNo;
    }

    @Override
    public final String yesNo() {
        return String.format(this.yesNo$str(), new Object[0]);
    }

    protected String secretElement$str() {
        return secretElement;
    }

    @Override
    public final String secretElement(String base64) {
        return String.format(this.secretElement$str(), base64);
    }

    protected String multipleAuthenticationMechanismsDefined$str() {
        return multipleAuthenticationMechanismsDefined;
    }

    @Override
    public final OperationFailedException multipleAuthenticationMechanismsDefined(String realmName, Set<String> mechanisms) {
        OperationFailedException result = new OperationFailedException(String.format(this.multipleAuthenticationMechanismsDefined$str(), realmName, mechanisms));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationFailedOneOfRequired$str() {
        return operationFailedOneOfRequired;
    }

    @Override
    public final OperationFailedException operationFailedOneOfRequired(String attr1, String attr2) {
        OperationFailedException result = new OperationFailedException(String.format(this.operationFailedOneOfRequired$str(), attr1, attr2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationFailedOnlyOneOfRequired$str() {
        return operationFailedOnlyOneOfRequired;
    }

    @Override
    public final OperationFailedException operationFailedOnlyOneOfRequired(String attr1, String attr2) {
        OperationFailedException result = new OperationFailedException(String.format(this.operationFailedOnlyOneOfRequired$str(), attr1, attr2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String canNotBeNull$str() {
        return canNotBeNull;
    }

    @Override
    public final IllegalArgumentException canNotBeNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.canNotBeNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSecurityContextEstablished$str() {
        return noSecurityContextEstablished;
    }

    @Override
    public final String noSecurityContextEstablished() {
        return String.format(this.noSecurityContextEstablished$str(), new Object[0]);
    }

    protected String filePrompt$str() {
        return filePrompt;
    }

    @Override
    public final String filePrompt() {
        return String.format(this.filePrompt$str(), new Object[0]);
    }

    protected String groupsPrompt$str() {
        return groupsPrompt;
    }

    @Override
    public final String groupsPrompt() {
        return String.format(this.groupsPrompt$str(), new Object[0]);
    }

    protected String addedGroups$str() {
        return addedGroups;
    }

    @Override
    public final String addedGroups(String username, String groups, String fileName) {
        return String.format(this.addedGroups$str(), username, groups, fileName);
    }

    protected String invalidChoiceResponse$str() {
        return invalidChoiceResponse;
    }

    @Override
    public final String invalidChoiceResponse() {
        return String.format(this.invalidChoiceResponse$str(), new Object[0]);
    }

    protected String aboutToUpdateEnabledUser$str() {
        return aboutToUpdateEnabledUser;
    }

    @Override
    public final String aboutToUpdateEnabledUser(String user) {
        return String.format(this.aboutToUpdateEnabledUser$str(), user);
    }

    protected String aboutToUpdateDisabledUser$str() {
        return aboutToUpdateDisabledUser;
    }

    @Override
    public final String aboutToUpdateDisabledUser(String user) {
        return String.format(this.aboutToUpdateDisabledUser$str(), user);
    }

    protected String updateUser$str() {
        return updateUser;
    }

    @Override
    public final String updateUser(String userName, String canonicalPath) {
        return String.format(this.updateUser$str(), userName, canonicalPath);
    }

    protected String unableToUpdateUser$str() {
        return unableToUpdateUser;
    }

    @Override
    public final String unableToUpdateUser(String absolutePath, String message) {
        return String.format(this.unableToUpdateUser$str(), absolutePath, message);
    }

    protected String updatedGroups$str() {
        return updatedGroups;
    }

    @Override
    public final String updatedGroups(String username, String groups, String fileName) {
        return String.format(this.updatedGroups$str(), username, groups, fileName);
    }

    protected String invalidLocalUser$str() {
        return invalidLocalUser;
    }

    @Override
    public final IOException invalidLocalUser(String userName) {
        IOException result = new IOException(String.format(this.invalidLocalUser$str(), userName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleCallbackHandlerForMechanism$str() {
        return multipleCallbackHandlerForMechanism;
    }

    @Override
    public final StartException multipleCallbackHandlerForMechanism(String mechanismName) {
        StartException result = new StartException(String.format(this.multipleCallbackHandlerForMechanism$str(), mechanismName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCallbackHandlerForMechanism$str() {
        return noCallbackHandlerForMechanism;
    }

    @Override
    public final IllegalStateException noCallbackHandlerForMechanism(String mechanism, String realmName) {
        IllegalStateException result = new IllegalStateException(String.format(this.noCallbackHandlerForMechanism$str(), mechanism, realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPlugInProvidersLoaded$str() {
        return noPlugInProvidersLoaded;
    }

    @Override
    public final IllegalArgumentException noPlugInProvidersLoaded(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noPlugInProvidersLoaded$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadPlugInProviders$str() {
        return unableToLoadPlugInProviders;
    }

    @Override
    public final IllegalArgumentException unableToLoadPlugInProviders(String name, String error) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unableToLoadPlugInProviders$str(), name, error));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAuthenticationPlugInFound$str() {
        return noAuthenticationPlugInFound;
    }

    @Override
    public final IllegalArgumentException noAuthenticationPlugInFound(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noAuthenticationPlugInFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitialisePlugIn$str() {
        return unableToInitialisePlugIn;
    }

    @Override
    public final IllegalStateException unableToInitialisePlugIn(String name, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToInitialisePlugIn$str(), name, message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordNotStrongEnough$str() {
        return passwordNotStrongEnough;
    }

    @Override
    public final String passwordNotStrongEnough(String currentStrength, String desiredStrength) {
        return String.format(this.passwordNotStrongEnough$str(), currentStrength, desiredStrength);
    }

    protected String passwordMustNotBeEqual$str() {
        return passwordMustNotBeEqual;
    }

    @Override
    public final PasswordValidationException passwordMustNotBeEqual(String password) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordMustNotBeEqual$str(), password));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordMustHaveDigit$str() {
        return passwordMustHaveDigit;
    }

    @Override
    public final String passwordMustHaveDigit(int minDigit) {
        return String.format(this.passwordMustHaveDigit$str(), minDigit);
    }

    protected String passwordMustHaveSymbol$str() {
        return passwordMustHaveSymbol;
    }

    @Override
    public final String passwordMustHaveSymbol(int minSymbol) {
        return String.format(this.passwordMustHaveSymbol$str(), minSymbol);
    }

    protected String passwordMustHaveAlpha$str() {
        return passwordMustHaveAlpha;
    }

    @Override
    public final String passwordMustHaveAlpha(int minAlpha) {
        return String.format(this.passwordMustHaveAlpha$str(), minAlpha);
    }

    protected String passwordNotLongEnough$str() {
        return passwordNotLongEnough;
    }

    @Override
    public final PasswordValidationException passwordNotLongEnough(int desiredLength) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordNotLongEnough$str(), desiredLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadKeyTrustFile$str() {
        return unableToLoadKeyTrustFile;
    }

    @Override
    public final IllegalStateException unableToLoadKeyTrustFile(Throwable t) {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToLoadKeyTrustFile$str(), new Object[0]), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOperateOnTrustStore$str() {
        return unableToOperateOnTrustStore;
    }

    @Override
    public final IllegalStateException unableToOperateOnTrustStore(GeneralSecurityException gse) {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToOperateOnTrustStore$str(), new Object[0]), gse);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateDelegateTrustManager$str() {
        return unableToCreateDelegateTrustManager;
    }

    @Override
    public final IllegalStateException unableToCreateDelegateTrustManager() {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToCreateDelegateTrustManager$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String onlyOneSyslogHandlerProtocol$str() {
        return onlyOneSyslogHandlerProtocol;
    }

    @Override
    public final XMLStreamException onlyOneSyslogHandlerProtocol(Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.onlyOneSyslogHandlerProtocol$str(), location));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noHandlerCalled$str() {
        return noHandlerCalled;
    }

    @Override
    public final IllegalStateException noHandlerCalled(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.noHandlerCalled$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sysLogProtocolAlreadyConfigured$str() {
        return sysLogProtocolAlreadyConfigured;
    }

    @Override
    public final OperationFailedException sysLogProtocolAlreadyConfigured(PathAddress append) {
        OperationFailedException result = new OperationFailedException(String.format(this.sysLogProtocolAlreadyConfigured$str(), append));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSyslogProtocol$str() {
        return noSyslogProtocol;
    }

    @Override
    public final OperationFailedException noSyslogProtocol() {
        OperationFailedException result = new OperationFailedException(String.format(this.noSyslogProtocol$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFormatterCalled$str() {
        return noFormatterCalled;
    }

    @Override
    public final OperationFailedException noFormatterCalled(String formatterName) {
        OperationFailedException result = new OperationFailedException(String.format(this.noFormatterCalled$str(), formatterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRemoveReferencedFormatter$str() {
        return cannotRemoveReferencedFormatter;
    }

    @Override
    public final OperationFailedException cannotRemoveReferencedFormatter(PathElement pathElement) {
        OperationFailedException result = new OperationFailedException(String.format(this.cannotRemoveReferencedFormatter$str(), pathElement));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String handlerAlreadyExists$str() {
        return handlerAlreadyExists;
    }

    @Override
    public final OperationFailedException handlerAlreadyExists(String name, PathAddress append) {
        OperationFailedException result = new OperationFailedException(String.format(this.handlerAlreadyExists$str(), name, append));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleRealmsDetected$str() {
        return multipleRealmsDetected;
    }

    @Override
    public final String multipleRealmsDetected(String realmOne, String realmTwo) {
        return String.format(this.multipleRealmsDetected$str(), realmOne, realmTwo);
    }

    protected String userRealmNotMatchDiscovered$str() {
        return userRealmNotMatchDiscovered;
    }

    @Override
    public final String userRealmNotMatchDiscovered(String supplied, String discovered) {
        return String.format(this.userRealmNotMatchDiscovered$str(), supplied, discovered);
    }

    protected String groupPropertiesButNoUserProperties$str() {
        return groupPropertiesButNoUserProperties;
    }

    @Override
    public final String groupPropertiesButNoUserProperties(String groupProperties) {
        return String.format(this.groupPropertiesButNoUserProperties$str(), groupProperties);
    }

    protected String realmMustBeSpecified$str() {
        return realmMustBeSpecified;
    }

    @Override
    public final String realmMustBeSpecified() {
        return String.format(this.realmMustBeSpecified$str(), new Object[0]);
    }

    protected String inconsistentRbacConfiguration$str() {
        return inconsistentRbacConfiguration;
    }

    @Override
    public final OperationFailedException inconsistentRbacConfiguration() {
        OperationFailedException result = new OperationFailedException(String.format(this.inconsistentRbacConfiguration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String inconsistentRbacRuntimeState$str() {
        return inconsistentRbacRuntimeState;
    }

    @Override
    public final OperationFailedException inconsistentRbacRuntimeState() {
        OperationFailedException result = new OperationFailedException(String.format(this.inconsistentRbacRuntimeState$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidChoiceUpdateUserResponse$str() {
        return invalidChoiceUpdateUserResponse;
    }

    @Override
    public final String invalidChoiceUpdateUserResponse() {
        return String.format(this.invalidChoiceUpdateUserResponse$str(), new Object[0]);
    }

    protected String duplicateIncludeExclude$str() {
        return duplicateIncludeExclude;
    }

    @Override
    public final OperationFailedException duplicateIncludeExclude(String roleName, String incExcl, String type, String name, String realm) {
        OperationFailedException result = new OperationFailedException(String.format(this.duplicateIncludeExclude$str(), roleName, incExcl, type, name, realm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleAuthorizationConfigurationsDefined$str() {
        return multipleAuthorizationConfigurationsDefined;
    }

    @Override
    public final OperationFailedException multipleAuthorizationConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.multipleAuthorizationConfigurationsDefined$str(), realmName, configurations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleUsernameToDnConfigurationsDefined$str() {
        return multipleUsernameToDnConfigurationsDefined;
    }

    @Override
    public final OperationFailedException multipleUsernameToDnConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.multipleUsernameToDnConfigurationsDefined$str(), realmName, configurations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGroupSearchDefined$str() {
        return noGroupSearchDefined;
    }

    @Override
    public final OperationFailedException noGroupSearchDefined(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.noGroupSearchDefined$str(), realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleGroupSearchConfigurationsDefined$str() {
        return multipleGroupSearchConfigurationsDefined;
    }

    @Override
    public final OperationFailedException multipleGroupSearchConfigurationsDefined(String realmName, Set<String> configurations) {
        OperationFailedException result = new OperationFailedException(String.format(this.multipleGroupSearchConfigurationsDefined$str(), realmName, configurations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoleName$str() {
        return invalidRoleName;
    }

    @Override
    public final OperationFailedException invalidRoleName(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.invalidRoleName$str(), roleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidRoleNameDomain$str() {
        return invalidRoleNameDomain;
    }

    @Override
    public final OperationFailedException invalidRoleNameDomain(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.invalidRoleNameDomain$str(), roleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String roleMappingRemaining$str() {
        return roleMappingRemaining;
    }

    @Override
    public final OperationFailedException roleMappingRemaining(String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.roleMappingRemaining$str(), roleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateScopedRole$str() {
        return duplicateScopedRole;
    }

    @Override
    public final OperationFailedException duplicateScopedRole(String scopeType, String roleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.duplicateScopedRole$str(), scopeType, roleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String scopedRoleStandardName$str() {
        return scopedRoleStandardName;
    }

    @Override
    public final OperationFailedException scopedRoleStandardName(String scopedRole, String standardRole) {
        OperationFailedException result = new OperationFailedException(String.format(this.scopedRoleStandardName$str(), scopedRole, standardRole));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badBaseRole$str() {
        return badBaseRole;
    }

    @Override
    public final OperationFailedException badBaseRole(String baseRole) {
        OperationFailedException result = new OperationFailedException(String.format(this.badBaseRole$str(), baseRole));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordUsernameMatchError$str() {
        return passwordUsernameMatchError;
    }

    @Override
    public final PasswordValidationException passwordUsernameMatchError() {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordUsernameMatchError$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noKey$str() {
        return noKey;
    }

    @Override
    public final StartException noKey(String path) {
        StartException result = new StartException(String.format(this.noKey$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String aliasNotKey$str() {
        return aliasNotKey;
    }

    @Override
    public final StartException aliasNotKey(String alias, String validList) {
        StartException result = new StartException(String.format(this.aliasNotKey$str(), alias, validList));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String aliasNotFound$str() {
        return aliasNotFound;
    }

    @Override
    public final StartException aliasNotFound(String alias, String validList) {
        StartException result = new StartException(String.format(this.aliasNotFound$str(), alias, validList));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreNotFound$str() {
        return keyStoreNotFound;
    }

    @Override
    public final StartException keyStoreNotFound(String path) {
        StartException result = new StartException(String.format(this.keyStoreNotFound$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleCacheConfigurationsDefined$str() {
        return multipleCacheConfigurationsDefined;
    }

    @Override
    public final OperationFailedException multipleCacheConfigurationsDefined(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.multipleCacheConfigurationsDefined$str(), realmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String usernameNotLoaded$str() {
        return usernameNotLoaded;
    }

    @Override
    public final NamingException usernameNotLoaded(String name) {
        NamingException result = new NamingException(String.format(this.usernameNotLoaded$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noNonProgressingOperationFound$str() {
        return noNonProgressingOperationFound;
    }

    @Override
    public final OperationFailedException noNonProgressingOperationFound(long timeout) {
        OperationFailedException result = new OperationFailedException(String.format(this.noNonProgressingOperationFound$str(), timeout));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeytab$str() {
        return invalidKeytab;
    }

    @Override
    public final StartException invalidKeytab(Exception cause) {
        StartException result = new StartException(String.format(this.invalidKeytab$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subjectIdentityLoggedOut$str() {
        return subjectIdentityLoggedOut;
    }

    @Override
    public final IllegalStateException subjectIdentityLoggedOut() {
        IllegalStateException result = new IllegalStateException(String.format(this.subjectIdentityLoggedOut$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToObtainTGT$str() {
        return unableToObtainTGT;
    }

    @Override
    public final OperationFailedException unableToObtainTGT(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.unableToObtainTGT$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void keytabLoginFailed(String principal, String host, LoginException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.keytabLoginFailed$str(), (Object)principal, (Object)host);
    }

    protected String keytabLoginFailed$str() {
        return keytabLoginFailed;
    }

    protected String kerberosWithoutKeytab$str() {
        return kerberosWithoutKeytab;
    }

    @Override
    public final OperationFailedException kerberosWithoutKeytab(String realm) {
        OperationFailedException result = new OperationFailedException(String.format(this.kerberosWithoutKeytab$str(), realm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCipherSuitesInCommon$str() {
        return noCipherSuitesInCommon;
    }

    @Override
    public final StartException noCipherSuitesInCommon(String supported, String requested) {
        StartException result = new StartException(String.format(this.noCipherSuitesInCommon$str(), supported, requested));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noProtocolsInCommon$str() {
        return noProtocolsInCommon;
    }

    @Override
    public final StartException noProtocolsInCommon(String supported, String requested) {
        StartException result = new StartException(String.format(this.noProtocolsInCommon$str(), supported, requested));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordShouldNotBeEqual$str() {
        return passwordShouldNotBeEqual;
    }

    @Override
    public final PasswordValidationException passwordShouldNotBeEqual(String password) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordShouldNotBeEqual$str(), password));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordUsernameShouldNotMatch$str() {
        return passwordUsernameShouldNotMatch;
    }

    @Override
    public final PasswordValidationException passwordUsernameShouldNotMatch() {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordUsernameShouldNotMatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordShouldHaveXCharacters$str() {
        return passwordShouldHaveXCharacters;
    }

    @Override
    public final PasswordValidationException passwordShouldHaveXCharacters(int desiredLength) {
        PasswordValidationException result = new PasswordValidationException(String.format(this.passwordShouldHaveXCharacters$str(), desiredLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordShouldHaveAlpha$str() {
        return passwordShouldHaveAlpha;
    }

    @Override
    public final String passwordShouldHaveAlpha(int minAlpha) {
        return String.format(this.passwordShouldHaveAlpha$str(), minAlpha);
    }

    protected String passwordShouldHaveDigit$str() {
        return passwordShouldHaveDigit;
    }

    @Override
    public final String passwordShouldHaveDigit(int minDigit) {
        return String.format(this.passwordShouldHaveDigit$str(), minDigit);
    }

    protected String passwordShouldHaveSymbol$str() {
        return passwordShouldHaveSymbol;
    }

    @Override
    public final String passwordShouldHaveSymbol(int minSymbol) {
        return String.format(this.passwordShouldHaveSymbol$str(), minSymbol);
    }

    protected String invalidSize$str() {
        return invalidSize;
    }

    @Override
    public final OperationFailedException invalidSize(String size) {
        OperationFailedException result = new OperationFailedException(String.format(this.invalidSize$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }

    @Override
    public final OperationFailedException suffixContainsMillis(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.suffixContainsMillis$str(), suffix));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSuffix$str() {
        return invalidSuffix;
    }

    @Override
    public final OperationFailedException invalidSuffix(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.invalidSuffix$str(), suffix));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String filePermissionsProblemsFound$str() {
        return filePermissionsProblemsFound;
    }

    @Override
    public final String filePermissionsProblemsFound(String file) {
        return String.format(this.filePermissionsProblemsFound$str(), file);
    }

    protected String domainRolloutNotProgressing$str() {
        return domainRolloutNotProgressing;
    }

    @Override
    public final OperationFailedException domainRolloutNotProgressing(String exclusiveLock, long timeout, String domainUUID, Collection relatedOps) {
        OperationFailedException result = new OperationFailedException(String.format(this.domainRolloutNotProgressing$str(), exclusiveLock, timeout, domainUUID, relatedOps));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedResource$str() {
        return unsupportedResource;
    }

    @Override
    public final IllegalStateException unsupportedResource(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.unsupportedResource$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyTabFileNotFound$str() {
        return keyTabFileNotFound;
    }

    @Override
    public final StartException keyTabFileNotFound(String fileName) {
        StartException result = new StartException(String.format(this.keyTabFileNotFound$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadSimpleNameForGroup$str() {
        return unableToLoadSimpleNameForGroup;
    }

    @Override
    public final NamingException unableToLoadSimpleNameForGroup(String distinguishedName) {
        NamingException result = new NamingException(String.format(this.unableToLoadSimpleNameForGroup$str(), distinguishedName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void keystoreWillBeCreated(String file, String host) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keystoreWillBeCreated$str(), (Object)file, (Object)host);
    }

    protected String keystoreWillBeCreated$str() {
        return keystoreWillBeCreated;
    }

    protected String failedToGenerateSelfSignedCertificate$str() {
        return failedToGenerateSelfSignedCertificate;
    }

    @Override
    public final RuntimeException failedToGenerateSelfSignedCertificate(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.failedToGenerateSelfSignedCertificate$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void keystoreHasBeenCreated(String file, String sha1, String sha256) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keystoreHasBeenCreated$str(), (Object)file, (Object)sha1, (Object)sha256);
    }

    protected String keystoreHasBeenCreated$str() {
        return keystoreHasBeenCreated;
    }

    protected String failedToCreateLazyInitSSLContext$str() {
        return failedToCreateLazyInitSSLContext;
    }

    @Override
    public final RuntimeException failedToCreateLazyInitSSLContext(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.failedToCreateLazyInitSSLContext$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSignatureAlgorithmNameGiven$str() {
        return noSignatureAlgorithmNameGiven;
    }

    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noSignatureAlgorithmNameGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSignatureAlgorithmName$str() {
        return unknownSignatureAlgorithmName;
    }

    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSigningKeyGiven$str() {
        return noSigningKeyGiven;
    }

    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noSigningKeyGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String signingKeyNotCompatWithSig$str() {
        return signingKeyNotCompatWithSig;
    }

    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(String signingKeyAlgorithm, String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String validAfterBeforeValidBefore$str() {
        return validAfterBeforeValidBefore;
    }

    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime notValidBefore, ZonedDateTime notValidAfter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIssuerDnGiven$str() {
        return noIssuerDnGiven;
    }

    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noIssuerDnGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPublicKeyGiven$str() {
        return noPublicKeyGiven;
    }

    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noPublicKeyGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String uniqueIdNotAllowed$str() {
        return uniqueIdNotAllowed;
    }

    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.uniqueIdNotAllowed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyForCert$str() {
        return invalidKeyForCert;
    }

    @Override
    public final IllegalArgumentException invalidKeyForCert(String publicKeyAlgorithm, Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certSigningFailed$str() {
        return certSigningFailed;
    }

    @Override
    public final IllegalArgumentException certSigningFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.certSigningFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serialNumberTooSmall$str() {
        return serialNumberTooSmall;
    }

    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.serialNumberTooSmall$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serialNumberTooLarge$str() {
        return serialNumberTooLarge;
    }

    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.serialNumberTooLarge$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSequenceToEnd$str() {
        return noSequenceToEnd;
    }

    @Override
    public final IllegalStateException noSequenceToEnd() {
        IllegalStateException result = new IllegalStateException(String.format(this.noSequenceToEnd$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSetToEnd$str() {
        return noSetToEnd;
    }

    @Override
    public final IllegalStateException noSetToEnd() {
        IllegalStateException result = new IllegalStateException(String.format(this.noSetToEnd$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noExplicitlyTaggedElementToEnd$str() {
        return noExplicitlyTaggedElementToEnd;
    }

    @Override
    public final IllegalStateException noExplicitlyTaggedElementToEnd() {
        IllegalStateException result = new IllegalStateException(String.format(this.noExplicitlyTaggedElementToEnd$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnInvalidOidCharacter$str() {
        return asnInvalidOidCharacter;
    }

    @Override
    public final IllegalArgumentException asnInvalidOidCharacter() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.asnInvalidOidCharacter$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnOidMustHaveAtLeast2Components$str() {
        return asnOidMustHaveAtLeast2Components;
    }

    @Override
    public final IllegalArgumentException asnOidMustHaveAtLeast2Components() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.asnOidMustHaveAtLeast2Components$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnInvalidValueForFirstOidComponent$str() {
        return asnInvalidValueForFirstOidComponent;
    }

    @Override
    public final IllegalArgumentException asnInvalidValueForFirstOidComponent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.asnInvalidValueForFirstOidComponent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnInvalidValueForSecondOidComponent$str() {
        return asnInvalidValueForSecondOidComponent;
    }

    @Override
    public final IllegalArgumentException asnInvalidValueForSecondOidComponent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.asnInvalidValueForSecondOidComponent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnInvalidLength$str() {
        return asnInvalidLength;
    }

    @Override
    public final IllegalArgumentException asnInvalidLength() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.asnInvalidLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String passwordUsernameMustMatchInfo$str() {
        return passwordUsernameMustMatchInfo;
    }

    @Override
    public final String passwordUsernameMustMatchInfo() {
        return String.format(this.passwordUsernameMustMatchInfo$str(), new Object[0]);
    }

    protected String passwordUsernameShouldMatchInfo$str() {
        return passwordUsernameShouldMatchInfo;
    }

    @Override
    public final String passwordUsernameShouldMatchInfo() {
        return String.format(this.passwordUsernameShouldMatchInfo$str(), new Object[0]);
    }

    protected String passwordMustNotEqualInfo$str() {
        return passwordMustNotEqualInfo;
    }

    @Override
    public final String passwordMustNotEqualInfo(String restricted) {
        return String.format(this.passwordMustNotEqualInfo$str(), restricted);
    }

    protected String passwordShouldNotEqualInfo$str() {
        return passwordShouldNotEqualInfo;
    }

    @Override
    public final String passwordShouldNotEqualInfo(String restricted) {
        return String.format(this.passwordShouldNotEqualInfo$str(), restricted);
    }

    protected String passwordLengthInfo$str() {
        return passwordLengthInfo;
    }

    @Override
    public final String passwordLengthInfo(int desiredLength) {
        return String.format(this.passwordLengthInfo$str(), desiredLength);
    }

    protected String passwordMustHaveAlphaInfo$str() {
        return passwordMustHaveAlphaInfo;
    }

    @Override
    public final String passwordMustHaveAlphaInfo(int minAlpha) {
        return String.format(this.passwordMustHaveAlphaInfo$str(), minAlpha);
    }

    protected String passwordMustHaveDigitInfo$str() {
        return passwordMustHaveDigitInfo;
    }

    @Override
    public final String passwordMustHaveDigitInfo(int minDigit) {
        return String.format(this.passwordMustHaveDigitInfo$str(), minDigit);
    }

    protected String passwordMustHaveSymbolInfo$str() {
        return passwordMustHaveSymbolInfo;
    }

    @Override
    public final String passwordMustHaveSymbolInfo(int minSymbol) {
        return String.format(this.passwordMustHaveSymbolInfo$str(), minSymbol);
    }

    protected String passwordMustContainInfo$str() {
        return passwordMustContainInfo;
    }

    @Override
    public final String passwordMustContainInfo(String requirements) {
        return String.format(this.passwordMustContainInfo$str(), requirements);
    }

    protected String passwordShouldContainInfo$str() {
        return passwordShouldContainInfo;
    }

    @Override
    public final String passwordShouldContainInfo(String requirements) {
        return String.format(this.passwordShouldContainInfo$str(), requirements);
    }

    protected String sureToSetPassword$str() {
        return sureToSetPassword;
    }

    @Override
    public final String sureToSetPassword() {
        return String.format(this.sureToSetPassword$str(), new Object[0]);
    }

    protected String argUsage$str() {
        return argUsage;
    }

    @Override
    public final String argUsage() {
        return String.format(this.argUsage$str(), new Object[0]);
    }

    protected String argApplicationUsers$str() {
        return argApplicationUsers;
    }

    @Override
    public final String argApplicationUsers() {
        return String.format(this.argApplicationUsers$str(), new Object[0]);
    }

    protected String argDomainConfigDirUsers$str() {
        return argDomainConfigDirUsers;
    }

    @Override
    public final String argDomainConfigDirUsers() {
        return String.format(this.argDomainConfigDirUsers$str(), new Object[0]);
    }

    protected String argServerConfigDirUsers$str() {
        return argServerConfigDirUsers;
    }

    @Override
    public final String argServerConfigDirUsers() {
        return String.format(this.argServerConfigDirUsers$str(), new Object[0]);
    }

    protected String argUserProperties$str() {
        return argUserProperties;
    }

    @Override
    public final String argUserProperties() {
        return String.format(this.argUserProperties$str(), new Object[0]);
    }

    protected String argGroupProperties$str() {
        return argGroupProperties;
    }

    @Override
    public final String argGroupProperties() {
        return String.format(this.argGroupProperties$str(), new Object[0]);
    }

    protected String argPassword$str() {
        return argPassword;
    }

    @Override
    public final String argPassword() {
        return String.format(this.argPassword$str(), new Object[0]);
    }

    protected String argUser$str() {
        return argUser;
    }

    @Override
    public final String argUser() {
        return String.format(this.argUser$str(), new Object[0]);
    }

    protected String argRealm$str() {
        return argRealm;
    }

    @Override
    public final String argRealm() {
        return String.format(this.argRealm$str(), new Object[0]);
    }

    protected String argSilent$str() {
        return argSilent;
    }

    @Override
    public final String argSilent() {
        return String.format(this.argSilent$str(), new Object[0]);
    }

    protected String argRole$str() {
        return argRole;
    }

    @Override
    public final String argRole() {
        return String.format(this.argRole$str(), new Object[0]);
    }

    protected String argGroup$str() {
        return argGroup;
    }

    @Override
    public final String argGroup() {
        return String.format(this.argGroup$str(), new Object[0]);
    }

    protected String argEnable$str() {
        return argEnable;
    }

    @Override
    public final String argEnable() {
        return String.format(this.argEnable$str(), new Object[0]);
    }

    protected String argDisable$str() {
        return argDisable;
    }

    @Override
    public final String argDisable() {
        return String.format(this.argDisable$str(), new Object[0]);
    }

    protected String argConfirmWarning$str() {
        return argConfirmWarning;
    }

    @Override
    public final String argConfirmWarning() {
        return String.format(this.argConfirmWarning$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return argHelp;
    }

    @Override
    public final String argHelp() {
        return String.format(this.argHelp$str(), new Object[0]);
    }

    protected String yes$str() {
        return yes;
    }

    @Override
    public final String yes() {
        return String.format(this.yes$str(), new Object[0]);
    }

    protected String shortYes$str() {
        return shortYes;
    }

    @Override
    public final String shortYes() {
        return String.format(this.shortYes$str(), new Object[0]);
    }

    protected String no$str() {
        return no;
    }

    @Override
    public final String no() {
        return String.format(this.no$str(), new Object[0]);
    }

    protected String shortNo$str() {
        return shortNo;
    }

    @Override
    public final String shortNo() {
        return String.format(this.shortNo$str(), new Object[0]);
    }

    protected String alternativeRealm$str() {
        return alternativeRealm;
    }

    @Override
    public final String alternativeRealm(String defaultRealm) {
        return String.format(this.alternativeRealm$str(), defaultRealm);
    }

    protected String realmConfirmation$str() {
        return realmConfirmation;
    }

    @Override
    public final String realmConfirmation(String chosenRealm) {
        return String.format(this.realmConfirmation$str(), chosenRealm);
    }

    protected String passwordRequirements$str() {
        return passwordRequirements;
    }

    @Override
    public final String passwordRequirements() {
        return String.format(this.passwordRequirements$str(), new Object[0]);
    }

    protected String passwordRecommendations$str() {
        return passwordRecommendations;
    }

    @Override
    public final String passwordRecommendations() {
        return String.format(this.passwordRecommendations$str(), new Object[0]);
    }

    protected String userSuppliedRealm$str() {
        return userSuppliedRealm;
    }

    @Override
    public final String userSuppliedRealm(String realmName) {
        return String.format(this.userSuppliedRealm$str(), realmName);
    }

    protected String discoveredRealm$str() {
        return discoveredRealm;
    }

    @Override
    public final String discoveredRealm(String realmName) {
        return String.format(this.discoveredRealm$str(), realmName);
    }
}

