/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.engine.impl.AnalyzerRegistry;

public class ImmutableAnalyzerRegistry
implements AnalyzerRegistry {
    private final AnalyzerReference defaultReference;
    private final AnalyzerReference passThroughReference;
    private final Map<String, AnalyzerReference> referencesByName;
    private final Map<Class<?>, AnalyzerReference> referencesByClass;

    ImmutableAnalyzerRegistry(AnalyzerRegistry registryState) {
        this.defaultReference = registryState.getDefaultAnalyzerReference();
        this.passThroughReference = registryState.getPassThroughAnalyzerReference();
        this.referencesByName = Collections.unmodifiableMap(new HashMap<String, AnalyzerReference>(registryState.getNamedAnalyzerReferences()));
        this.referencesByClass = Collections.unmodifiableMap(new HashMap(registryState.getLuceneClassAnalyzerReferences()));
    }

    @Override
    public AnalyzerReference getDefaultAnalyzerReference() {
        return this.defaultReference;
    }

    @Override
    public AnalyzerReference getPassThroughAnalyzerReference() {
        return this.passThroughReference;
    }

    @Override
    public Map<String, AnalyzerReference> getNamedAnalyzerReferences() {
        return this.referencesByName;
    }

    @Override
    public Map<Class<?>, AnalyzerReference> getLuceneClassAnalyzerReferences() {
        return this.referencesByClass;
    }

    @Override
    public AnalyzerReference getAnalyzerReference(String name) {
        return this.referencesByName.get(name);
    }

    @Override
    public AnalyzerReference getAnalyzerReference(Class<?> analyzerClazz) {
        return this.referencesByClass.get(analyzerClazz);
    }

    @Override
    public void close() {
        this.close(this.referencesByClass.values());
    }

    private void close(Collection<AnalyzerReference> references) {
        for (AnalyzerReference reference : references) {
            reference.close();
        }
    }
}

