/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestSuccessReporter;

public class BackendRequest<T extends JestResult> {
    private final Action<T> action;
    private final LuceneWork luceneWork;
    private final String indexName;
    private final IndexingMonitor indexingMonitor;
    private final BackendRequestResultAssessor<? super T> resultAssessor;
    private final BackendRequestSuccessReporter<? super T> successReporter;
    private final boolean refreshAfterWrite;

    public BackendRequest(Action<T> action, LuceneWork luceneWork, String indexName, BackendRequestResultAssessor<? super T> resultAssessor, IndexingMonitor indexingMonitor, BackendRequestSuccessReporter<? super T> successReporter, boolean refreshAfterWrite) {
        this.action = action;
        this.luceneWork = luceneWork;
        this.indexName = indexName;
        this.resultAssessor = resultAssessor;
        this.indexingMonitor = indexingMonitor;
        this.successReporter = successReporter;
        this.refreshAfterWrite = refreshAfterWrite;
    }

    public LuceneWork getLuceneWork() {
        return this.luceneWork;
    }

    public Action<T> getAction() {
        return this.action;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public BackendRequestResultAssessor<? super T> getResultAssessor() {
        return this.resultAssessor;
    }

    public IndexingMonitor getIndexingMonitor() {
        return this.indexingMonitor;
    }

    public BackendRequestSuccessReporter<? super T> getSuccessReporter() {
        return this.successReporter;
    }

    public boolean needsRefreshAfterWrite() {
        return this.refreshAfterWrite;
    }

    public String toString() {
        return "BackendRequest [action=" + this.action + ", resultAssessor=" + this.resultAssessor + "]";
    }
}

