/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.nulls.impl;

import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchBooleanNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchDoubleNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchFloatNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchIntegerNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchLongNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchStringNullMarkerCodec;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ElasticsearchMissingValueStrategy
implements MissingValueStrategy {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    public static final ElasticsearchMissingValueStrategy INSTANCE = new ElasticsearchMissingValueStrategy();

    public NullMarkerCodec createNullMarkerCodec(Class<?> entityType, DocumentFieldPath path, NullMarker nullMarker) {
        Object nullEncoded = nullMarker.nullEncoded();
        if (nullEncoded instanceof String) {
            return new ElasticsearchStringNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Integer) {
            return new ElasticsearchIntegerNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Long) {
            return new ElasticsearchLongNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Float) {
            return new ElasticsearchFloatNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Double) {
            return new ElasticsearchDoubleNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Boolean) {
            return new ElasticsearchBooleanNullMarkerCodec(nullMarker);
        }
        throw LOG.unsupportedNullTokenType(entityType, path.getAbsoluteName(), nullEncoded.getClass());
    }
}

