/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.bridge.builtin.impl.ElasticsearchBridgeDefinedField;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchMappingBuilder;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchSchemaTranslator
implements ElasticsearchSchemaTranslator {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);

    @Override
    public IndexMetadata translate(String indexName, Collection<EntityIndexBinding> descriptors, ExecutionOptions executionOptions) {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setName(indexName);
        ElasticsearchIndexSettingsBuilder settingsBuilder = new ElasticsearchIndexSettingsBuilder();
        for (EntityIndexBinding descriptor : descriptors) {
            String typeName = descriptor.getDocumentBuilder().getBeanClass().getName();
            TypeMapping mapping = this.translate(descriptor, settingsBuilder, executionOptions);
            indexMetadata.putMapping(typeName, mapping);
        }
        indexMetadata.setSettings(settingsBuilder.build());
        return indexMetadata;
    }

    private TypeMapping translate(EntityIndexBinding descriptor, ElasticsearchIndexSettingsBuilder settingsBuilder, ExecutionOptions executionOptions) {
        TypeMapping root = new TypeMapping();
        root.setDynamic(executionOptions.getDynamicMapping());
        ElasticsearchMappingBuilder mappingBuilder = new ElasticsearchMappingBuilder(descriptor, root);
        if (executionOptions.isMultitenancyEnabled()) {
            PropertyMapping tenantId = new PropertyMapping();
            tenantId.setType(DataType.STRING);
            tenantId.setIndex(IndexType.NOT_ANALYZED);
            mappingBuilder.setPropertyAbsolute("__HSearch_TenantId", tenantId);
        }
        this.addMappings(mappingBuilder, settingsBuilder, executionOptions);
        return root;
    }

    private void addMappings(ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, ExecutionOptions executionOptions) {
        TypeMetadata typeMetadata = mappingBuilder.getMetadata();
        for (DocumentFieldMetadata fieldMetadata : typeMetadata.getNonEmbeddedDocumentFieldMetadata()) {
            try {
                this.addPropertyMapping(mappingBuilder, settingsBuilder, fieldMetadata, executionOptions);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for field " + fieldMetadata.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        for (BridgeDefinedField bridgeDefinedField : this.getNonEmbeddedBridgeDefinedFields(typeMetadata)) {
            try {
                this.addPropertyMapping(mappingBuilder, settingsBuilder, bridgeDefinedField);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for field " + bridgeDefinedField.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            ElasticsearchMappingBuilder embeddedContext = new ElasticsearchMappingBuilder(mappingBuilder, embeddedTypeMetadata);
            this.addMappings(embeddedContext, settingsBuilder, executionOptions);
        }
    }

    private void addPropertyMapping(ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, DocumentFieldMetadata fieldMetadata, ExecutionOptions executionOptions) {
        if (fieldMetadata.getAbsoluteName().isEmpty() || fieldMetadata.getAbsoluteName().endsWith(".") || fieldMetadata.isSpatial()) {
            return;
        }
        String propertyPath = fieldMetadata.getAbsoluteName();
        PropertyMapping propertyMapping = new PropertyMapping();
        this.addTypeOptions(propertyMapping, fieldMetadata);
        if (propertyMapping.getType() != DataType.OBJECT) {
            propertyMapping.setStore(fieldMetadata.getStore() != Store.NO);
        }
        this.addIndexOptions(propertyMapping, mappingBuilder, settingsBuilder, fieldMetadata.getSourceProperty(), fieldMetadata.getAbsoluteName(), fieldMetadata.getIndex(), fieldMetadata.getAnalyzerReference());
        if (propertyMapping.getType() != DataType.OBJECT) {
            propertyMapping.setBoost(Float.valueOf(mappingBuilder.getBoost(fieldMetadata.getBoost())));
        }
        this.logDynamicBoostWarning(mappingBuilder, fieldMetadata.getSourceType().getDynamicBoost(), propertyPath);
        PropertyMetadata sourceProperty = fieldMetadata.getSourceProperty();
        if (sourceProperty != null) {
            this.logDynamicBoostWarning(mappingBuilder, sourceProperty.getDynamicBoostStrategy(), propertyPath);
        }
        this.addNullValue(propertyMapping, mappingBuilder, fieldMetadata);
        for (FacetMetadata facetMetadata : fieldMetadata.getFacetMetadata()) {
            try {
                this.addSubfieldMapping(propertyMapping, mappingBuilder, facetMetadata);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for facet " + facetMetadata.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
    }

    private void logDynamicBoostWarning(ElasticsearchMappingBuilder mappingBuilder, BoostStrategy dynamicBoostStrategy, String fieldPath) {
        if (dynamicBoostStrategy != null && !DefaultBoostStrategy.INSTANCE.equals(dynamicBoostStrategy)) {
            LOG.unsupportedDynamicBoost(dynamicBoostStrategy.getClass(), mappingBuilder.getBeanClass(), fieldPath);
        }
    }

    private void addPropertyMapping(ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, BridgeDefinedField bridgeDefinedField) {
        String propertyPath = bridgeDefinedField.getAbsoluteName();
        if (!SpatialHelper.isSpatialField((String)propertyPath)) {
            if (!mappingBuilder.hasPropertyAbsolute(propertyPath)) {
                PropertyMapping propertyMapping = new PropertyMapping();
                this.addTypeOptions(propertyMapping, bridgeDefinedField);
                this.addIndexOptions(propertyMapping, mappingBuilder, settingsBuilder, bridgeDefinedField.getSourceField().getSourceProperty(), propertyPath, bridgeDefinedField.getIndex(), null);
                this.addDynamicOption(bridgeDefinedField, propertyMapping);
                mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
            } else {
                TypeMapping propertyMapping = mappingBuilder.getPropertyAbsolute(propertyPath);
                this.addDynamicOption(bridgeDefinedField, propertyMapping);
            }
        } else {
            if (SpatialHelper.isSpatialFieldLongitude((String)propertyPath)) {
                return;
            }
            if (SpatialHelper.isSpatialFieldLatitude((String)propertyPath)) {
                PropertyMapping propertyMapping = new PropertyMapping();
                propertyMapping.setType(DataType.GEO_POINT);
                mappingBuilder.setPropertyAbsolute(SpatialHelper.stripSpatialFieldSuffix((String)propertyPath), propertyMapping);
            } else {
                PropertyMapping propertyMapping = new PropertyMapping();
                propertyMapping.setType(DataType.STRING);
                propertyMapping.setIndex(IndexType.NOT_ANALYZED);
                mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
            }
        }
    }

    private void addDynamicOption(BridgeDefinedField bridgeDefinedField, TypeMapping propertyMapping) {
        ElasticsearchBridgeDefinedField mappedOn = (ElasticsearchBridgeDefinedField)bridgeDefinedField.getBridgeDefinedField(ElasticsearchBridgeDefinedField.class);
        if (mappedOn != null && mappedOn.getDynamic() != null) {
            propertyMapping.setDynamic(DynamicType.valueOf(mappedOn.getDynamic().name().toUpperCase(Locale.ROOT)));
        }
    }

    private void addSubfieldMapping(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, FacetMetadata facetMetadata) {
        String facetFieldName = facetMetadata.getPath().getRelativeName() + "__HSearch_Facet";
        PropertyMapping fieldMapping = new PropertyMapping();
        this.addTypeOptions(fieldMapping, facetMetadata);
        fieldMapping.setStore(false);
        fieldMapping.setIndex(IndexType.NOT_ANALYZED);
        propertyMapping.addField(facetFieldName, fieldMapping);
    }

    private void addIndexOptions(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, PropertyMetadata sourceProperty, String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        if (propertyMapping.getType() != DataType.OBJECT) {
            IndexType elasticsearchIndex = this.elasticsearchIndexType(propertyMapping, index);
            propertyMapping.setIndex(elasticsearchIndex);
            if (IndexType.NO.equals((Object)elasticsearchIndex) && FieldHelper.isSortableField(mappingBuilder.getMetadata(), sourceProperty, propertyPath)) {
                propertyMapping.setDocValues(true);
            }
            if (IndexType.ANALYZED.equals((Object)elasticsearchIndex) && analyzerReference != null) {
                if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
                    LOG.analyzerIsNotElasticsearch(mappingBuilder.getBeanClass(), propertyPath, analyzerReference);
                } else {
                    ElasticsearchAnalyzerReference elasticsearchReference = (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
                    ElasticsearchAnalyzer analyzer = elasticsearchReference.getAnalyzer();
                    String analyzerName = settingsBuilder.register(analyzer, propertyPath);
                    propertyMapping.setAnalyzer(analyzerName);
                }
            }
        }
    }

    private IndexType elasticsearchIndexType(PropertyMapping propertyMapping, Field.Index index) {
        switch (index) {
            case ANALYZED: 
            case ANALYZED_NO_NORMS: {
                return this.canTypeBeAnalyzed(propertyMapping.getType()) ? IndexType.ANALYZED : IndexType.NOT_ANALYZED;
            }
            case NOT_ANALYZED: 
            case NOT_ANALYZED_NO_NORMS: {
                return IndexType.NOT_ANALYZED;
            }
            case NO: {
                return IndexType.NO;
            }
        }
        throw new AssertionFailure("Unexpected index type: " + index);
    }

    private boolean canTypeBeAnalyzed(DataType fieldType) {
        return DataType.STRING.equals((Object)fieldType);
    }

    private void addTypeOptions(PropertyMapping propertyMapping, DocumentFieldMetadata fieldMetadata) {
        this.addTypeOptions(fieldMetadata.getAbsoluteName(), propertyMapping, FieldHelper.getType(fieldMetadata));
    }

    private void addTypeOptions(PropertyMapping propertyMapping, BridgeDefinedField bridgeDefinedField) {
        FieldHelper.ExtendedFieldType type = FieldHelper.getType(bridgeDefinedField);
        if (FieldHelper.ExtendedFieldType.UNKNOWN.equals((Object)type)) {
            throw LOG.unexpectedFieldType(bridgeDefinedField.getType().name(), bridgeDefinedField.getAbsoluteName());
        }
        this.addTypeOptions(bridgeDefinedField.getAbsoluteName(), propertyMapping, type);
    }

    private void addTypeOptions(PropertyMapping fieldMapping, FacetMetadata facetMetadata) {
        FieldHelper.ExtendedFieldType type;
        if (facetMetadata.isEncodingAuto()) {
            this.addTypeOptions(fieldMapping, facetMetadata.getSourceField());
            return;
        }
        switch (facetMetadata.getEncoding()) {
            case DOUBLE: {
                type = FieldHelper.ExtendedFieldType.DOUBLE;
                break;
            }
            case LONG: {
                type = FieldHelper.ExtendedFieldType.LONG;
                break;
            }
            case STRING: {
                type = FieldHelper.ExtendedFieldType.STRING;
                break;
            }
            case AUTO: {
                throw new AssertionFailure("The facet type should have been resolved during bootstrapping");
            }
            default: {
                throw new AssertionFailure("Unexpected facet encoding type '" + facetMetadata.getEncoding() + "' Has the enum been modified?");
            }
        }
        this.addTypeOptions(facetMetadata.getAbsoluteName(), fieldMapping, type);
    }

    private DataType addTypeOptions(String fieldName, PropertyMapping propertyMapping, FieldHelper.ExtendedFieldType extendedType) {
        DataType elasticsearchType;
        ArrayList<String> formats = new ArrayList<String>();
        switch (extendedType) {
            case BOOLEAN: {
                elasticsearchType = DataType.BOOLEAN;
                break;
            }
            case CALENDAR: 
            case DATE: 
            case INSTANT: {
                elasticsearchType = DataType.DATE;
                break;
            }
            case LOCAL_DATE: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date");
                formats.add("yyyyyyyyy-MM-dd");
                break;
            }
            case LOCAL_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date_hour_minute_second_fraction");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
                break;
            }
            case LOCAL_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_hour_minute_second_fraction");
                break;
            }
            case OFFSET_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date_time");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ");
                break;
            }
            case OFFSET_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_time");
                break;
            }
            case ZONED_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("yyyy-MM-dd'T'HH:mm:ss.SSSZZ'['ZZZ']'");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ'['ZZZ']'");
                break;
            }
            case YEAR: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_year");
                formats.add("yyyyyyyyy");
                break;
            }
            case YEAR_MONTH: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_year_month");
                formats.add("yyyyyyyyy-MM");
                break;
            }
            case MONTH_DAY: {
                elasticsearchType = DataType.DATE;
                formats.add("--MM-dd");
                break;
            }
            case INTEGER: {
                elasticsearchType = DataType.INTEGER;
                break;
            }
            case LONG: {
                elasticsearchType = DataType.LONG;
                break;
            }
            case FLOAT: {
                elasticsearchType = DataType.FLOAT;
                break;
            }
            case DOUBLE: {
                elasticsearchType = DataType.DOUBLE;
                break;
            }
            case OBJECT: {
                elasticsearchType = DataType.OBJECT;
                break;
            }
            case UNKNOWN_NUMERIC: {
                elasticsearchType = null;
                break;
            }
            default: {
                elasticsearchType = DataType.STRING;
            }
        }
        if (elasticsearchType == null) {
            throw new IncompleteDataException("Field type could not be determined");
        }
        propertyMapping.setType(elasticsearchType);
        if (!formats.isEmpty()) {
            propertyMapping.setFormat(formats);
        }
        return elasticsearchType;
    }

    private void addNullValue(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, DocumentFieldMetadata fieldMetadata) {
        NullMarkerCodec nullMarkerCodec = fieldMetadata.getNullMarkerCodec();
        NullMarker nullMarker = nullMarkerCodec.getNullMarker();
        if (nullMarker != null) {
            JsonPrimitive nullTokenJson = this.convertIndexedNullTokenToJson(mappingBuilder, fieldMetadata.getPath(), nullMarker.nullEncoded());
            propertyMapping.setNullValue(nullTokenJson);
        }
    }

    private JsonPrimitive convertIndexedNullTokenToJson(ElasticsearchMappingBuilder mappingBuilder, DocumentFieldPath fieldPath, Object indexedNullToken) {
        if (indexedNullToken == null) {
            return null;
        }
        if (indexedNullToken instanceof String) {
            return new JsonPrimitive((String)indexedNullToken);
        }
        if (indexedNullToken instanceof Number) {
            return new JsonPrimitive((Number)indexedNullToken);
        }
        if (indexedNullToken instanceof Boolean) {
            return new JsonPrimitive((Boolean)indexedNullToken);
        }
        throw LOG.unsupportedNullTokenType(mappingBuilder.getBeanClass(), fieldPath.getAbsoluteName(), indexedNullToken.getClass());
    }

    private Set<BridgeDefinedField> getNonEmbeddedBridgeDefinedFields(TypeMetadata type) {
        HashSet<BridgeDefinedField> bridgeDefinedFields = new HashSet<BridgeDefinedField>();
        for (DocumentFieldMetadata documentFieldMetadata : type.getNonEmbeddedDocumentFieldMetadata()) {
            bridgeDefinedFields.addAll(documentFieldMetadata.getBridgeDefinedFields().values());
        }
        return bridgeDefinedFields;
    }

    private static class IncompleteDataException
    extends SearchException {
        public IncompleteDataException(String message) {
            super(message);
        }
    }
}

