/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.writercache.CharBlockArray;

class CategoryPathUtils {
    CategoryPathUtils() {
    }

    public static void serialize(FacetLabel cp, CharBlockArray charBlockArray) {
        charBlockArray.append((char)cp.length);
        if (cp.length == 0) {
            return;
        }
        for (int i = 0; i < cp.length; ++i) {
            charBlockArray.append((char)cp.components[i].length());
            charBlockArray.append(cp.components[i]);
        }
    }

    public static int hashCodeOfSerialized(CharBlockArray charBlockArray, int offset) {
        int length;
        if ((length = charBlockArray.charAt(offset++)) == 0) {
            return 0;
        }
        int hash = length;
        for (int i = 0; i < length; ++i) {
            char len = charBlockArray.charAt(offset++);
            hash = hash * 31 + charBlockArray.subSequence(offset, offset + len).hashCode();
            offset += len;
        }
        return hash;
    }

    public static boolean equalsToSerialized(FacetLabel cp, CharBlockArray charBlockArray, int offset) {
        char n;
        if (cp.length != (n = charBlockArray.charAt(offset++))) {
            return false;
        }
        if (cp.length == 0) {
            return true;
        }
        for (int i = 0; i < cp.length; ++i) {
            char len;
            if ((len = charBlockArray.charAt(offset++)) != cp.components[i].length()) {
                return false;
            }
            if (!cp.components[i].equals(charBlockArray.subSequence(offset, offset + len))) {
                return false;
            }
            offset += len;
        }
        return true;
    }
}

