/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class PutStreamOperation
extends AbstractKeyOperation<OutputStream> {
    static final long VERSION_PUT = 0L;
    static final long VERSION_PUT_IF_ABSENT = -1L;
    private final long version;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;
    private boolean retryable;

    public PutStreamOperation(Codec codec, TransportFactory transportFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, ClientIntelligence clientIntelligence, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, transportFactory, key, keyBytes, cacheName, topologyId, flags, clientIntelligence);
        this.version = version;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
        this.retryable = true;
    }

    @Override
    public OutputStream executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)57);
        transport.writeArray(this.keyBytes);
        this.codec.writeExpirationParams(transport, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        transport.writeLong(this.version);
        this.retryable = false;
        transport.setBusy(true);
        return this.codec.writeAsStream(transport, () -> {
            try {
                short status = this.readHeaderAndValidate(transport, params);
                if (!HotRodConstants.isSuccess(status)) {
                    if (HotRodConstants.isNotExecuted(status) && this.version != 0L) {
                        return;
                    }
                    throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
                }
            }
            finally {
                transport.setBusy(false);
                transport.getTransportFactory().releaseTransport(transport);
            }
        });
    }

    @Override
    protected boolean shouldRetry(int retryCount) {
        return this.retryable && super.shouldRetry(retryCount);
    }
}

