/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.core.configuration.SslConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SslEngineConfigurationBuilder
implements SslConfigurationChildBuilder {
    private static final Log log = (Log)LogFactory.getLog(SslEngineConfigurationBuilder.class, Log.class);
    private final SslConfigurationBuilder parentSslConfigurationBuilder;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private SSLContext sslContext;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private char[] keyStoreCertificatePassword;
    private String domain = "*";

    SslEngineConfigurationBuilder(SslConfigurationBuilder parentSslConfigurationBuilder) {
        this.parentSslConfigurationBuilder = parentSslConfigurationBuilder;
    }

    public SslEngineConfigurationBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SslEngineConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslEngineConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslEngineConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslEngineConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslEngineConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this;
    }

    public void validate() {
        if (this.domain == null) {
            throw log.noSniDomainConfigured();
        }
        if (this.sslContext == null) {
            if (this.keyStoreFileName == null) {
                throw log.noSSLKeyManagerConfiguration();
            }
            if (this.keyStoreFileName != null && this.keyStorePassword == null) {
                throw log.missingKeyStorePassword(this.keyStoreFileName);
            }
            if (this.trustStoreFileName != null && this.trustStorePassword == null) {
                throw log.missingTrustStorePassword(this.trustStoreFileName);
            }
        } else if (this.keyStoreFileName != null || this.trustStoreFileName != null) {
            throw log.xorSSLContext();
        }
    }

    public SslEngineConfiguration create() {
        return new SslEngineConfiguration(this.keyStoreFileName, this.keyStorePassword, this.keyStoreCertificatePassword, this.sslContext, this.trustStoreFileName, this.trustStorePassword);
    }

    public SslEngineConfigurationBuilder read(SslEngineConfiguration template) {
        this.keyStoreFileName = template.keyStoreFileName();
        this.keyStorePassword = template.keyStorePassword();
        this.sslContext = template.sslContext();
        this.trustStoreFileName = template.trustStoreFileName();
        this.trustStorePassword = template.trustStorePassword();
        return this;
    }

    @Override
    public SslEngineConfigurationBuilder sniHostName(String domain) {
        return this.parentSslConfigurationBuilder.sniHostName(domain);
    }
}

