/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import org.jboss.as.logging.deployments.LoggingConfigurationService;
import org.jboss.as.logging.deployments.resources.LoggingDeploymentResources;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LoggingDeploymentResourceProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<LoggingConfigurationService> LOGGING_CONFIGURATION_SERVICE_KEY = AttachmentKey.create(LoggingConfigurationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE)) {
            LoggingConfigurationService loggingConfigurationService = null;
            if (deploymentUnit.hasAttachment(LOGGING_CONFIGURATION_SERVICE_KEY)) {
                loggingConfigurationService = (LoggingConfigurationService)deploymentUnit.getAttachment(LOGGING_CONFIGURATION_SERVICE_KEY);
                deploymentUnit.removeAttachment(LOGGING_CONFIGURATION_SERVICE_KEY);
            } else {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
                    LogContextConfiguration logContextConfiguration = null;
                    LogContext logContext = LogContext.getLogContext();
                    Configurator configurator = (Configurator)logContext.getAttachment("", Configurator.ATTACHMENT_KEY);
                    if (configurator instanceof LogContextConfiguration) {
                        logContextConfiguration = (LogContextConfiguration)configurator;
                    } else if (configurator instanceof PropertyConfigurator) {
                        logContextConfiguration = ((PropertyConfigurator)configurator).getLogContextConfiguration();
                    }
                    loggingConfigurationService = new LoggingConfigurationService(logContextConfiguration, "default");
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                }
            }
            DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, loggingConfigurationService);
            phaseContext.getServiceTarget().addService(LoggingConfigurationService.forDeployment(deploymentUnit), (Service)loggingConfigurationService).install();
        }
    }

    public final void undeploy(DeploymentUnit context) {
    }
}

