/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.SimpleInstanceAttributeCopier;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;

public class HashConfiguration {
    public static final AttributeDefinition<ConsistentHashFactory> CONSISTENT_HASH_FACTORY = AttributeDefinition.builder((String)"consistentHashFactory", null, ConsistentHashFactory.class).immutable().build();
    public static final AttributeDefinition<Hash> HASH = AttributeDefinition.builder((String)"hash", (Object)MurmurHash3.getInstance()).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((String)"numOwners", (Object)2).xmlName("owners").immutable().build();
    public static final AttributeDefinition<Integer> NUM_SEGMENTS = AttributeDefinition.builder((String)"numSegments", (Object)256).xmlName("segments").immutable().build();
    public static final AttributeDefinition<Float> CAPACITY_FACTOR = AttributeDefinition.builder((String)"capacityFactor", (Object)Float.valueOf(1.0f)).immutable().xmlName("capacity").build();
    public static final AttributeDefinition<KeyPartitioner> KEY_PARTITIONER = AttributeDefinition.builder((String)"keyPartitioner", (Object)new HashFunctionPartitioner(), KeyPartitioner.class).copier(SimpleInstanceAttributeCopier.INSTANCE).immutable().build();
    private final Attribute<ConsistentHashFactory> consistentHashFactory;
    private final Attribute<Hash> hash;
    private final Attribute<Integer> numOwners;
    private final Attribute<Integer> numSegments;
    private final Attribute<Float> capacityFactor;
    private final Attribute<KeyPartitioner> keyPartitioner;
    private final GroupsConfiguration groupsConfiguration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HashConfiguration.class, new AttributeDefinition[]{CONSISTENT_HASH_FACTORY, HASH, NUM_OWNERS, NUM_SEGMENTS, CAPACITY_FACTOR, KEY_PARTITIONER});
    }

    HashConfiguration(AttributeSet attributes, GroupsConfiguration groupsConfiguration, StateTransferConfiguration stateTransferConfiguration) {
        this.attributes = attributes.checkProtection();
        this.groupsConfiguration = groupsConfiguration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.consistentHashFactory = attributes.attribute(CONSISTENT_HASH_FACTORY);
        this.hash = attributes.attribute(HASH);
        this.numOwners = attributes.attribute(NUM_OWNERS);
        this.numSegments = attributes.attribute(NUM_SEGMENTS);
        this.capacityFactor = attributes.attribute(CAPACITY_FACTOR);
        this.keyPartitioner = attributes.attribute(KEY_PARTITIONER);
    }

    @Deprecated
    public ConsistentHash consistentHash() {
        return null;
    }

    public ConsistentHashFactory<?> consistentHashFactory() {
        return (ConsistentHashFactory)this.consistentHashFactory.get();
    }

    @Deprecated
    public Hash hash() {
        return (Hash)this.hash.get();
    }

    public int numOwners() {
        return (Integer)this.numOwners.get();
    }

    public int numSegments() {
        return (Integer)this.numSegments.get();
    }

    @Deprecated
    public boolean rehashEnabled() {
        return this.stateTransferConfiguration.fetchInMemoryState();
    }

    @Deprecated
    public long rehashRpcTimeout() {
        return this.stateTransferConfiguration.timeout();
    }

    @Deprecated
    public long rehashWait() {
        return this.stateTransferConfiguration.timeout();
    }

    public float capacityFactor() {
        return ((Float)this.capacityFactor.get()).floatValue();
    }

    public KeyPartitioner keyPartitioner() {
        return (KeyPartitioner)this.keyPartitioner.get();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "HashConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashConfiguration other = (HashConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

