/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.executors.SecurityAwareExecutorFactory;
import org.infinispan.commons.util.TypedProperties;

public class DefaultExecutorFactory
implements SecurityAwareExecutorFactory {
    private final AtomicInteger counter = new AtomicInteger(0);

    public ExecutorService getExecutor(Properties p) {
        return this.getExecutor(p, null);
    }

    public ExecutorService getExecutor(Properties p, final AccessControlContext context) {
        TypedProperties tp = TypedProperties.toTypedProperties((Properties)p);
        int maxThreads = tp.getIntProperty("maxThreads", 1);
        int queueSize = tp.getIntProperty("queueSize", 100000);
        int coreThreads = queueSize == 0 ? 1 : tp.getIntProperty("coreThreads", maxThreads);
        long keepAliveTime = tp.getLongProperty("keepAliveTime", 60000L);
        final int threadPrio = tp.getIntProperty("threadPriority", 1);
        final String threadNamePrefix = tp.getProperty("threadNamePrefix", tp.getProperty("componentName", "Thread"));
        final String threadNameSuffix = tp.getProperty("threadNameSuffix", "");
        SynchronousQueue<Runnable> queue = queueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
        ThreadFactory tf = new ThreadFactory(){

            private Thread createThread(Runnable r) {
                String threadName = threadNamePrefix + "-" + DefaultExecutorFactory.this.counter.getAndIncrement() + threadNameSuffix;
                Thread th = new Thread(r, threadName);
                th.setDaemon(true);
                th.setPriority(threadPrio);
                return th;
            }

            @Override
            public Thread newThread(Runnable r) {
                AccessControlContext acc;
                final Runnable runnable = r;
                if (System.getSecurityManager() != null && (acc = context) != null) {
                    return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                        @Override
                        public Thread run() {
                            return this.createThread(runnable);
                        }
                    }, acc);
                }
                return this.createThread(runnable);
            }
        };
        return new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, queue, tf, new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

