/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.BaseCacheStream;
import org.infinispan.CacheStream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;
import org.infinispan.stream.impl.termop.SegmentRetryingOperation;
import org.infinispan.stream.impl.termop.SingleRunOperation;
import org.infinispan.stream.impl.termop.object.FlatMapIteratorOperation;
import org.infinispan.stream.impl.termop.object.MapIteratorOperation;
import org.infinispan.stream.impl.termop.object.NoMapIteratorOperation;
import org.infinispan.util.RangeSet;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheStream<T, S extends BaseStream<T, S>, S2 extends S>
implements BaseStream<T, S> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Queue<IntermediateOperation> intermediateOperations;
    protected final Address localAddress;
    protected final DistributionManager dm;
    protected final Supplier<CacheStream<CacheEntry>> supplier;
    protected final ClusterStreamManager csm;
    protected final boolean includeLoader;
    protected final Executor executor;
    protected final ComponentRegistry registry;
    protected final PartitionHandlingManager partition;
    protected final KeyPartitioner keyPartitioner;
    protected Runnable closeRunnable = null;
    protected boolean parallel;
    protected Boolean parallelDistribution;
    protected boolean rehashAware = true;
    protected Set<?> keysToFilter;
    protected Set<Integer> segmentsToFilter;
    protected int distributedBatchSize;
    protected BaseCacheStream.SegmentCompletionListener segmentCompletionListener;
    protected IteratorOperation iteratorOperation = IteratorOperation.NO_MAP;
    protected long timeout = 30L;
    protected TimeUnit timeoutUnit = TimeUnit.SECONDS;

    protected AbstractCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<CacheEntry>> supplier, ClusterStreamManager<Object> csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry) {
        this.localAddress = localAddress;
        this.parallel = parallel;
        this.dm = dm;
        this.supplier = supplier;
        this.csm = csm;
        this.includeLoader = includeLoader;
        this.distributedBatchSize = distributedBatchSize;
        this.executor = executor;
        this.registry = registry;
        this.partition = registry.getComponent(PartitionHandlingManager.class);
        this.keyPartitioner = registry.getComponent(KeyPartitioner.class);
        this.intermediateOperations = new ArrayDeque<IntermediateOperation>();
    }

    protected AbstractCacheStream(AbstractCacheStream<T, S, S2> other) {
        this.intermediateOperations = other.intermediateOperations;
        this.localAddress = other.localAddress;
        this.dm = other.dm;
        this.supplier = other.supplier;
        this.csm = other.csm;
        this.includeLoader = other.includeLoader;
        this.executor = other.executor;
        this.registry = other.registry;
        this.partition = other.partition;
        this.keyPartitioner = other.keyPartitioner;
        this.closeRunnable = other.closeRunnable;
        this.parallel = other.parallel;
        this.parallelDistribution = other.parallelDistribution;
        this.rehashAware = other.rehashAware;
        this.keysToFilter = other.keysToFilter;
        this.segmentsToFilter = other.segmentsToFilter;
        this.distributedBatchSize = other.distributedBatchSize;
        this.segmentCompletionListener = other.segmentCompletionListener;
        this.iteratorOperation = other.iteratorOperation;
        this.timeout = other.timeout;
        this.timeoutUnit = other.timeoutUnit;
    }

    protected S2 addIntermediateOperation(IntermediateOperation<T, S, T, S> intermediateOperation) {
        intermediateOperation.handleInjection(this.registry);
        this.addIntermediateOperation(this.intermediateOperations, intermediateOperation);
        return this.unwrap();
    }

    protected void addIntermediateOperationMap(IntermediateOperation<T, S, ?, ?> intermediateOperation) {
        intermediateOperation.handleInjection(this.registry);
        this.addIntermediateOperation(this.intermediateOperations, intermediateOperation);
    }

    protected void addIntermediateOperation(Queue<IntermediateOperation> intermediateOperations, IntermediateOperation<T, S, ?, ?> intermediateOperation) {
        intermediateOperations.add(intermediateOperation);
    }

    protected abstract S2 unwrap();

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    boolean getParallelDistribution() {
        return this.parallelDistribution == null ? true : this.parallelDistribution;
    }

    @Override
    public S2 sequential() {
        this.parallel = false;
        return this.unwrap();
    }

    @Override
    public S2 parallel() {
        this.parallel = true;
        return this.unwrap();
    }

    @Override
    public S2 unordered() {
        return this.unwrap();
    }

    @Override
    public S2 onClose(Runnable closeHandler) {
        this.closeRunnable = this.closeRunnable == null ? closeHandler : AbstractCacheStream.composeWithExceptions(this.closeRunnable, closeHandler);
        return this.unwrap();
    }

    @Override
    public void close() {
        if (this.closeRunnable != null) {
            this.closeRunnable.run();
        }
    }

    <R> R performOperation(Function<? super S2, ? extends R> function, boolean retryOnRehash, BinaryOperator<R> accumulator, Predicate<? super R> earlyTerminatePredicate) {
        ResultsAccumulator<R> remoteResults = new ResultsAccumulator<R>(accumulator);
        if (this.rehashAware) {
            return this.performOperationRehashAware(function, retryOnRehash, remoteResults, earlyTerminatePredicate);
        }
        return this.performOperation(function, remoteResults, earlyTerminatePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R performOperation(Function<? super S2, ? extends R> function, ResultsAccumulator<R> remoteResults, Predicate<? super R> earlyTerminatePredicate) {
        ConsistentHash ch = this.dm.getWriteConsistentHash();
        SingleRunOperation op = new SingleRunOperation(this.intermediateOperations, this.supplierForSegments(ch, this.segmentsToFilter, null), function);
        Object id = this.csm.remoteStreamOperation(this.getParallelDistribution(), this.parallel, ch, this.segmentsToFilter, this.keysToFilter, Collections.emptyMap(), this.includeLoader, op, remoteResults, earlyTerminatePredicate);
        try {
            Object localValue = op.performOperation();
            remoteResults.onCompletion(null, Collections.emptySet(), localValue);
            if (id != null) {
                try {
                    if (!(earlyTerminatePredicate != null && earlyTerminatePredicate.test(localValue) || this.csm.awaitCompletion(id, this.timeout, this.timeoutUnit))) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
            }
            this.log.tracef("Finished operation for id %s", id);
            Object r = remoteResults.currentValue;
            return r;
        }
        finally {
            this.csm.forgetOperation(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R performOperationRehashAware(Function<? super S2, ? extends R> function, boolean retryOnRehash, ResultsAccumulator<R> remoteResults, Predicate<? super R> earlyTerminatePredicate) {
        Set<Integer> segmentsToProcess = this.segmentsToFilter;
        do {
            ConsistentHash ch = this.dm.getReadConsistentHash();
            BaseTerminalOperation op = retryOnRehash ? new SegmentRetryingOperation(this.intermediateOperations, this.supplierForSegments(ch, segmentsToProcess, null), function) : new SingleRunOperation(this.intermediateOperations, this.supplierForSegments(ch, segmentsToProcess, null), function);
            Object id = this.csm.remoteStreamOperationRehashAware(this.getParallelDistribution(), this.parallel, ch, segmentsToProcess, this.keysToFilter, Collections.emptyMap(), this.includeLoader, op, remoteResults, earlyTerminatePredicate);
            try {
                Object localValue;
                boolean localRun = ch.getMembers().contains(this.localAddress);
                if (localRun) {
                    Set<Integer> ourSegments;
                    localValue = op.performOperation();
                    if (this.dm.getReadConsistentHash().equals(ch)) {
                        ourSegments = ch.getPrimarySegmentsForOwner(this.localAddress);
                        if (segmentsToProcess != null) {
                            ourSegments.retainAll(segmentsToProcess);
                        }
                        remoteResults.onCompletion(null, ourSegments, localValue);
                    } else if (segmentsToProcess != null) {
                        ourSegments = ch.getPrimarySegmentsForOwner(this.localAddress);
                        ourSegments.retainAll(segmentsToProcess);
                        remoteResults.onSegmentsLost(ourSegments);
                    } else {
                        remoteResults.onSegmentsLost(ch.getPrimarySegmentsForOwner(this.localAddress));
                    }
                } else {
                    localValue = null;
                }
                if (id != null) {
                    try {
                        if (!(localRun && earlyTerminatePredicate != null && earlyTerminatePredicate.test(localValue) || this.csm.awaitCompletion(id, this.timeout, this.timeoutUnit))) {
                            throw new TimeoutException();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
                if (!((ResultsAccumulator)remoteResults).lostSegments.isEmpty()) {
                    segmentsToProcess = new HashSet<Integer>(((ResultsAccumulator)remoteResults).lostSegments);
                    ((ResultsAccumulator)remoteResults).lostSegments.clear();
                    this.log.tracef("Found %s lost segments for identifier %s", segmentsToProcess, id);
                    continue;
                }
                if (segmentsToProcess != null) {
                    segmentsToProcess = null;
                }
                this.log.tracef("Finished rehash aware operation for id %s", id);
            }
            finally {
                this.csm.forgetOperation(id);
            }
        } while (segmentsToProcess != null && !segmentsToProcess.isEmpty());
        return remoteResults.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performRehashKeyTrackingOperation(Function<Supplier<Stream<CacheEntry>>, KeyTrackingTerminalOperation<Object, ? extends T, Object>> function) {
        Set<Integer> segmentsToProcess;
        AtomicBoolean complete = new AtomicBoolean();
        ConsistentHash segmentInfoCH = this.dm.getReadConsistentHash();
        KeyTrackingConsumer results = new KeyTrackingConsumer(this.keyPartitioner, segmentInfoCH, c -> {}, c -> c, null);
        Set<Integer> set = segmentsToProcess = this.segmentsToFilter == null ? new RangeSet(segmentInfoCH.getNumSegments()) : this.segmentsToFilter;
        do {
            Set<Object> excludedKeys;
            Set<Integer> segments;
            ConsistentHash ch;
            boolean localRun;
            if (localRun = (ch = this.dm.getReadConsistentHash()).getMembers().contains(this.localAddress)) {
                segments = ch.getPrimarySegmentsForOwner(this.localAddress);
                segments.retainAll(segmentsToProcess);
                excludedKeys = segments.stream().flatMap(s -> results.referenceArray.get((int)s).stream()).collect(Collectors.toSet());
            } else {
                segments = null;
                excludedKeys = Collections.emptySet();
            }
            KeyTrackingTerminalOperation<Object, T, Object> op = function.apply(this.supplierForSegments(ch, segmentsToProcess, excludedKeys));
            op.handleInjection(this.registry);
            Object id = this.csm.remoteStreamOperationRehashAware(this.getParallelDistribution(), this.parallel, ch, segmentsToProcess, this.keysToFilter, new AtomicReferenceArrayToMap(results.referenceArray), this.includeLoader, op, results);
            try {
                if (localRun) {
                    Collection localValue = op.performOperationRehashAware(results);
                    if (this.dm.getReadConsistentHash().equals(ch)) {
                        this.log.tracef("Found local values %s for id %s", localValue.size(), id);
                        results.onCompletion((Address)null, segments, localValue);
                    } else {
                        Set<Integer> ourSegments = ch.getPrimarySegmentsForOwner(this.localAddress);
                        ourSegments.retainAll(segmentsToProcess);
                        this.log.tracef("CH changed - making %s segments suspect for identifier %s", ourSegments, id);
                        results.onSegmentsLost(ourSegments);
                        results.onIntermediateResult((Address)null, localValue);
                    }
                }
                if (id != null) {
                    try {
                        if (!this.csm.awaitCompletion(id, this.timeout, this.timeoutUnit)) {
                            throw new TimeoutException();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
                if (!results.lostSegments.isEmpty()) {
                    segmentsToProcess = new HashSet<Integer>(results.lostSegments);
                    results.lostSegments.clear();
                    this.log.tracef("Found %s lost segments for identifier %s", segmentsToProcess, id);
                    continue;
                }
                this.log.tracef("Finished rehash aware operation for id %s", id);
                complete.set(true);
            }
            finally {
                this.csm.forgetOperation(id);
            }
        } while (!complete.get());
    }

    protected boolean isPrimaryOwner(ConsistentHash ch, CacheEntry e) {
        return this.localAddress.equals(ch.locatePrimaryOwnerForSegment(this.keyPartitioner.getSegment(e.getKey())));
    }

    protected Supplier<Stream<CacheEntry>> supplierForSegments(ConsistentHash ch, Set<Integer> targetSegments, Set<Object> excludedKeys) {
        return this.supplierForSegments(ch, targetSegments, excludedKeys, true);
    }

    protected Supplier<Stream<CacheEntry>> supplierForSegments(ConsistentHash ch, Set<Integer> targetSegments, Set<Object> excludedKeys, boolean usePrimary) {
        Set<Integer> segments;
        if (!ch.getMembers().contains(this.localAddress)) {
            return Stream::empty;
        }
        if (usePrimary) {
            segments = ch.getPrimarySegmentsForOwner(this.localAddress);
            if (targetSegments != null) {
                segments.retainAll(targetSegments);
            }
        } else {
            segments = targetSegments;
        }
        return () -> {
            if (segments.isEmpty()) {
                return Stream.empty();
            }
            BaseCacheStream stream = this.supplier.get().filterKeySegments((Set)segments);
            if (this.keysToFilter != null) {
                stream = stream.filterKeys((Set)this.keysToFilter);
            }
            if (excludedKeys != null) {
                return stream.filter(e -> !excludedKeys.contains(e.getKey()));
            }
            return this.parallel ? stream.parallel() : stream.sequential();
        };
    }

    static Runnable composeWithExceptions(Runnable a, Runnable b) {
        return () -> {
            try {
                a.run();
            }
            catch (Throwable e1) {
                try {
                    b.run();
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e1;
            }
            b.run();
        };
    }

    protected static BaseCacheStream.SegmentCompletionListener composeWithExceptions(BaseCacheStream.SegmentCompletionListener a, BaseCacheStream.SegmentCompletionListener b) {
        return segments -> {
            try {
                a.segmentCompleted(segments);
            }
            catch (Throwable e1) {
                try {
                    b.segmentCompleted(segments);
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e1;
            }
            b.segmentCompleted(segments);
        };
    }

    static class CollectionDecomposerConsumer<E>
    implements Consumer<Iterable<E>> {
        private final Consumer<E> consumer;

        CollectionDecomposerConsumer(Consumer<E> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(Iterable<E> es) {
            es.forEach(this.consumer);
        }
    }

    static enum IteratorOperation {
        NO_MAP{

            @Override
            public KeyTrackingTerminalOperation getOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
                return new NoMapIteratorOperation(intermediateOperations, supplier, batchSize);
            }

            @Override
            public <K, V, R> Function<CacheEntry<K, V>, R> getFunction() {
                return e -> e;
            }
        }
        ,
        MAP{

            @Override
            public KeyTrackingTerminalOperation getOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
                return new MapIteratorOperation(intermediateOperations, supplier, batchSize);
            }
        }
        ,
        FLAT_MAP{

            @Override
            public KeyTrackingTerminalOperation getOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
                return new FlatMapIteratorOperation(intermediateOperations, supplier, batchSize);
            }

            @Override
            public <V, V2> Consumer<V2> wrapConsumer(Consumer<V> consumer) {
                return new CollectionDecomposerConsumer<V>(consumer);
            }
        };


        public abstract KeyTrackingTerminalOperation getOperation(Iterable<IntermediateOperation> var1, Supplier<Stream<CacheEntry>> var2, int var3);

        public <K, V, R> Function<CacheEntry<K, V>, R> getFunction() {
            return e -> e.getValue();
        }

        public <V, V2> Consumer<V2> wrapConsumer(Consumer<V> consumer) {
            return consumer;
        }
    }

    static class CollectionConsumer<R>
    implements ClusterStreamManager.ResultsCallback<Collection<R>>,
    KeyTrackingTerminalOperation.IntermediateCollector<Collection<R>> {
        private final Consumer<R> consumer;

        CollectionConsumer(Consumer<R> consumer) {
            this.consumer = consumer;
        }

        @Override
        public Set<Integer> onIntermediateResult(Address address, Collection<R> results) {
            if (results != null) {
                results.forEach(this.consumer);
            }
            return null;
        }

        @Override
        public void onCompletion(Address address, Set<Integer> completedSegments, Collection<R> results) {
            this.onIntermediateResult(address, results);
        }

        @Override
        public void onSegmentsLost(Set<Integer> segments) {
        }

        @Override
        public void sendDataResonse(Collection<R> response) {
            this.onIntermediateResult((Address)null, response);
        }
    }

    static class ResultsAccumulator<R>
    implements ClusterStreamManager.ResultsCallback<R> {
        private final BinaryOperator<R> binaryOperator;
        private final Set<Integer> lostSegments = new ConcurrentHashSet();
        R currentValue;

        ResultsAccumulator(BinaryOperator<R> binaryOperator) {
            this.binaryOperator = binaryOperator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Integer> onIntermediateResult(Address address, R results) {
            if (results != null) {
                ResultsAccumulator resultsAccumulator = this;
                synchronized (resultsAccumulator) {
                    this.currentValue = this.currentValue != null ? this.binaryOperator.apply(this.currentValue, results) : results;
                }
            }
            return null;
        }

        @Override
        public void onCompletion(Address address, Set<Integer> completedSegments, R results) {
            this.onIntermediateResult(address, results);
        }

        @Override
        public void onSegmentsLost(Set<Integer> segments) {
            for (Integer segment : segments) {
                this.lostSegments.add(segment);
            }
        }
    }

    class KeyTrackingConsumer<K, V>
    implements ClusterStreamManager.ResultsCallback<Collection<CacheEntry<K, Object>>>,
    KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, Object>>> {
        final KeyPartitioner keyPartitioner;
        final ConsistentHash ch;
        final Consumer<V> consumer;
        final Set<Integer> lostSegments = new ConcurrentHashSet();
        final Function<CacheEntry<K, Object>, V> valueFunction;
        final AtomicReferenceArray<Set<K>> referenceArray;
        final DistributedCacheStream.SegmentListenerNotifier listenerNotifier;

        KeyTrackingConsumer(KeyPartitioner keyPartitioner, ConsistentHash ch, Consumer<V> consumer, Function<CacheEntry<K, Object>, V> valueFunction, DistributedCacheStream.SegmentListenerNotifier completedSegments) {
            this.keyPartitioner = keyPartitioner;
            this.ch = ch;
            this.consumer = consumer;
            this.valueFunction = valueFunction;
            this.listenerNotifier = completedSegments;
            this.referenceArray = new AtomicReferenceArray(ch.getNumSegments());
            for (int i = 0; i < this.referenceArray.length(); ++i) {
                this.referenceArray.set(i, new HashSet());
            }
        }

        @Override
        public Set<Integer> onIntermediateResult(Address address, Collection<CacheEntry<K, Object>> results) {
            if (results != null) {
                AbstractCacheStream.this.log.tracef("Response from %s with results %s", address, results.size());
                CacheEntry[] lastCompleted = new CacheEntry[1];
                HashSet<Integer> segmentsCompleted = this.listenerNotifier != null ? new HashSet<Integer>() : null;
                results.forEach(e -> {
                    Object key = e.getKey();
                    int segment = this.keyPartitioner.getSegment(key);
                    Set<K> keys = this.referenceArray.get(segment);
                    if (keys != null) {
                        keys.add(key);
                    } else if (segmentsCompleted != null) {
                        segmentsCompleted.add(segment);
                        lastCompleted[0] = e;
                    }
                    this.consumer.accept(this.valueFunction.apply((CacheEntry<K, Object>)e));
                });
                if (lastCompleted[0] != null) {
                    this.listenerNotifier.addSegmentsForObject(this.valueFunction.apply(lastCompleted[0]), segmentsCompleted);
                }
                return segmentsCompleted;
            }
            return null;
        }

        @Override
        public void onCompletion(Address address, Set<Integer> completedSegments, Collection<CacheEntry<K, Object>> results) {
            if (!completedSegments.isEmpty()) {
                AbstractCacheStream.this.log.tracef("Completing segments %s", completedSegments);
                completedSegments.forEach(s -> this.referenceArray.set((int)s, (Set<K>)null));
            } else {
                AbstractCacheStream.this.log.tracef("No segments to complete from %s", address);
            }
            Set<Integer> valueSegments = this.onIntermediateResult(address, results);
            if (valueSegments != null) {
                HashSet<Integer> emptyCompletedSegments = new HashSet<Integer>(completedSegments.size());
                completedSegments.forEach(s -> {
                    if (!valueSegments.contains(s)) {
                        emptyCompletedSegments.add((Integer)s);
                    }
                });
                this.listenerNotifier.completeSegmentsNoResults(emptyCompletedSegments);
            }
        }

        @Override
        public void onSegmentsLost(Set<Integer> segments) {
            for (Integer segment : segments) {
                this.lostSegments.add(segment);
            }
        }

        @Override
        public void sendDataResonse(Collection<CacheEntry<K, Object>> response) {
            this.onIntermediateResult((Address)null, response);
        }
    }

    static class AtomicReferenceArrayToMap<R>
    extends AbstractMap<Integer, R> {
        final AtomicReferenceArray<R> array;

        AtomicReferenceArrayToMap(AtomicReferenceArray<R> array) {
            this.array = array;
        }

        @Override
        public boolean containsKey(Object o) {
            if (!(o instanceof Integer)) {
                return false;
            }
            int i = (Integer)o;
            return 0 <= i && i < this.array.length();
        }

        @Override
        public R get(Object key) {
            if (!(key instanceof Integer)) {
                return null;
            }
            int i = (Integer)key;
            if (0 <= i && i < this.array.length()) {
                return this.array.get(i);
            }
            return null;
        }

        @Override
        public int size() {
            return this.array.length();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Integer, R>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

