/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.UUID;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EmbeddedBaseTransactionManager
implements TransactionManager {
    private static final Log log = LogFactory.getLog(EmbeddedBaseTransactionManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private static ThreadLocal<EmbeddedTransaction> CURRENT_TRANSACTION = new ThreadLocal();
    final UUID transactionManagerId = UUID.randomUUID();

    static void associateTransaction(Transaction tx) {
        CURRENT_TRANSACTION.set((EmbeddedTransaction)tx);
    }

    static void dissociateTransaction() {
        CURRENT_TRANSACTION.remove();
    }

    public void begin() throws NotSupportedException, SystemException {
        EmbeddedTransaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        EmbeddedBaseTransactionManager.associateTransaction(new EmbeddedTransaction(this));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().commit();
        EmbeddedBaseTransactionManager.dissociateTransaction();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransactionAndFailIfNone().rollback();
        EmbeddedBaseTransactionManager.dissociateTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        EmbeddedTransaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public EmbeddedTransaction getTransaction() {
        return CURRENT_TRANSACTION.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public Transaction suspend() throws SystemException {
        EmbeddedTransaction tx = this.getTransaction();
        EmbeddedBaseTransactionManager.dissociateTransaction();
        if (trace) {
            log.tracef("Suspending tx %s", tx);
        }
        return tx;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (trace) {
            log.tracef("Resuming tx %s", tx);
        }
        EmbeddedBaseTransactionManager.associateTransaction(tx);
    }

    private EmbeddedTransaction getTransactionAndFailIfNone() {
        EmbeddedTransaction transaction = CURRENT_TRANSACTION.get();
        if (transaction == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        return transaction;
    }
}

