/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search.spi;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.store.spi.LockFactoryCreator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.hibernate.search.impl.AsyncDeleteExecutorService;
import org.infinispan.hibernate.search.impl.LoggerFactory;
import org.infinispan.hibernate.search.logging.Log;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.hibernate.search.spi.InfinispanIntegration;
import org.infinispan.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.WithinThreadExecutor;

public class InfinispanDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = LoggerFactory.make();
    private ServiceManager serviceManager;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private Integer chunkSize;
    private Directory directory;
    private EmbeddedCacheManager cacheManager;
    private AsyncDeleteExecutorService deletesExecutor;
    private boolean writeFileListAsync;
    private LockFactory indexWriterLockFactory;
    private int affinityId;
    private boolean isAsync;

    public InfinispanDirectoryProvider(int affinityId) {
        this.affinityId = affinityId;
    }

    public InfinispanDirectoryProvider() {
        this.affinityId = -1;
    }

    public void initialize(String directoryProviderName, Properties properties, org.hibernate.search.spi.BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.cacheManager = ((CacheManagerService)this.serviceManager.requestService(CacheManagerService.class)).getEmbeddedCacheManager();
        this.metadataCacheName = InfinispanIntegration.getMetadataCacheName(properties);
        this.dataCacheName = InfinispanIntegration.getDataCacheName(properties);
        this.lockingCacheName = InfinispanIntegration.getLockingCacheName(properties);
        this.chunkSize = ConfigurationParseHelper.getIntValue(properties, "chunk_size");
        this.writeFileListAsync = this.getWriteFileListAsync(properties);
        if (this.configurationExplicitlySetsLockFactory(properties)) {
            File verifiedIndexDir = null;
            if (this.isNativeLockingStrategy(properties)) {
                verifiedIndexDir = DirectoryHelper.getVerifiedIndexDir((String)directoryProviderName, (Properties)properties, (boolean)true);
            }
            this.indexWriterLockFactory = this.getLockFactory(verifiedIndexDir, properties);
        }
        this.isAsync = !BackendFactory.isConfiguredAsSync((Properties)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockFactory getLockFactory(File indexDir, Properties properties) {
        try {
            LockFactory lockFactory = ((LockFactoryCreator)this.serviceManager.requestService(LockFactoryCreator.class)).createLockFactory(indexDir, properties);
            return lockFactory;
        }
        finally {
            this.serviceManager.releaseService(LockFactoryCreator.class);
        }
    }

    private boolean getWriteFileListAsync(Properties properties) {
        return ConfigurationParseHelper.getBooleanValue(properties, "write_metadata_async", false);
    }

    private boolean configurationExplicitlySetsLockFactory(Properties dirConfiguration) {
        return dirConfiguration.getProperty("locking_strategy") != null;
    }

    private boolean isNativeLockingStrategy(Properties dirConfiguration) {
        return "native".equals(dirConfiguration.getProperty("locking_strategy"));
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        log.debug("Starting InfinispanDirectory");
        this.deletesExecutor = this.getDeleteOperationsExecutor();
        this.validateCacheManagerConfiguration();
        this.cacheManager.startCaches(new String[]{this.metadataCacheName, this.dataCacheName, this.lockingCacheName});
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        BuildContext directoryBuildContext = DirectoryBuilder.newDirectoryInstance((Cache)metadataCache, (Cache)dataCache, (Cache)lockingCache, (String)this.directoryProviderName).writeFileListAsynchronously(this.writeFileListAsync).deleteOperationsExecutor((Executor)(this.isAsync ? new WithinThreadExecutor() : this.deletesExecutor.getExecutor()));
        if (this.chunkSize != null) {
            directoryBuildContext.chunkSize(this.chunkSize.intValue());
        }
        if (this.indexWriterLockFactory != null) {
            directoryBuildContext.overrideWriteLocker(this.indexWriterLockFactory);
        }
        if (this.affinityId >= 0) {
            directoryBuildContext.affinityLocationIntoSegment(this.affinityId);
        }
        this.directory = directoryBuildContext.create();
        DirectoryHelper.initializeIndexIfNeeded((Directory)this.directory);
        log.debugf("Initialized Infinispan index: '%s'", this.directoryProviderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void validateCacheManagerConfiguration() {
        ConfigurationBuilder builder;
        Class<InfinispanDirectoryProvider> clazz;
        if (this.cacheManager.getCacheConfiguration(this.metadataCacheName) == null) {
            clazz = InfinispanDirectoryProvider.class;
            // MONITORENTER : org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider.class
            if (this.cacheManager.getCacheConfiguration(this.metadataCacheName) == null) {
                log.missingIndexCacheConfiguration(this.metadataCacheName);
                builder = new ConfigurationBuilder();
                if (this.cacheManager.getCacheManagerConfiguration().isClustered()) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(25000L).stateTransfer().awaitInitialTransfer(true).timeout(480000L).locking().useLockStriping(false).lockAcquisitionTimeout(10000L).concurrencyLevel(500);
                } else {
                    builder.simpleCache(true);
                }
                this.cacheManager.defineConfiguration(this.metadataCacheName, builder.build());
            }
            // MONITOREXIT : clazz
        }
        if (this.cacheManager.getCacheConfiguration(this.dataCacheName) == null) {
            clazz = InfinispanDirectoryProvider.class;
            // MONITORENTER : org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider.class
            if (this.cacheManager.getCacheConfiguration(this.dataCacheName) == null) {
                log.missingIndexCacheConfiguration(this.dataCacheName);
                builder = new ConfigurationBuilder();
                if (this.cacheManager.getCacheManagerConfiguration().isClustered()) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC).remoteTimeout(25000L).stateTransfer().awaitInitialTransfer(true).timeout(480000L).locking().useLockStriping(false).lockAcquisitionTimeout(10000L).concurrencyLevel(500);
                } else {
                    builder.simpleCache(true);
                }
                this.cacheManager.defineConfiguration(this.dataCacheName, builder.build());
            }
            // MONITOREXIT : clazz
        }
        if (this.cacheManager.getCacheConfiguration(this.lockingCacheName) != null) return;
        clazz = InfinispanDirectoryProvider.class;
        // MONITORENTER : org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider.class
        if (this.cacheManager.getCacheConfiguration(this.lockingCacheName) == null) {
            log.missingIndexCacheConfiguration(this.lockingCacheName);
            builder = new ConfigurationBuilder();
            if (this.cacheManager.getCacheManagerConfiguration().isClustered()) {
                builder.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(25000L).stateTransfer().awaitInitialTransfer(true).timeout(480000L).locking().useLockStriping(false).lockAcquisitionTimeout(10000L).concurrencyLevel(500);
            } else {
                builder.simpleCache(true);
            }
            this.cacheManager.defineConfiguration(this.lockingCacheName, builder.build());
        }
        // MONITOREXIT : clazz
    }

    private AsyncDeleteExecutorService getDeleteOperationsExecutor() {
        return (AsyncDeleteExecutorService)this.serviceManager.requestService(AsyncDeleteExecutorService.class);
    }

    public int pendingDeleteTasks() {
        return this.isAsync ? 0 : this.deletesExecutor.getActiveTasks();
    }

    public void stop() {
        this.deletesExecutor.closeAndFlush();
        this.serviceManager.releaseService(AsyncDeleteExecutorService.class);
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.unableToCloseLuceneDirectory(this.directory, e);
        }
        this.serviceManager.releaseService(CacheManagerService.class);
        log.debug("Stopped InfinispanDirectory");
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Address getLockOwner(String indexName, int affinityId, String lockName) {
        FileCacheKey fileCacheKey = new FileCacheKey(indexName, lockName, affinityId);
        Cache lockCache = this.cacheManager.getCache(this.lockingCacheName);
        Address address = (Address)lockCache.get((Object)fileCacheKey);
        log.debugf("Lock owner for %s: %s", fileCacheKey, address);
        return address;
    }
}

