/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.impl.TypedProperties;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private static final Log log = LogFactory.getLog(SslConfigurationBuilder.class);
    private boolean enabled = false;
    private String keyStoreFileName;
    private String keyStoreType;
    private char[] keyStorePassword;
    private char[] keyStoreCertificatePassword;
    private String keyAlias;
    private String trustStoreFileName;
    private String trustStoreType;
    private char[] trustStorePassword;
    private SSLContext sslContext;
    private String sniHostName;
    private String protocol;

    protected SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this;
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.sniHostName = sniHostName;
        return this;
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public void validate() {
        if (this.enabled) {
            if (this.sslContext == null) {
                if (this.keyStoreFileName != null && this.keyStorePassword == null) {
                    throw log.missingKeyStorePassword(this.keyStoreFileName);
                }
                if (this.trustStoreFileName == null) {
                    throw log.noSSLTrustManagerConfiguration();
                }
                if (this.trustStoreFileName != null && this.trustStorePassword == null) {
                    throw log.missingTrustStorePassword(this.trustStoreFileName);
                }
            } else if (this.keyStoreFileName != null || this.trustStoreFileName != null) {
                throw log.xorSSLContext();
            }
        }
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.enabled, this.keyStoreFileName, this.keyStoreType, this.keyStorePassword, this.keyStoreCertificatePassword, this.keyAlias, this.sslContext, this.trustStoreFileName, this.trustStoreType, this.trustStorePassword, this.sniHostName, this.protocol);
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.enabled = template.enabled();
        this.keyStoreFileName = template.keyStoreFileName();
        this.keyStoreType = template.keyStoreType();
        this.keyStorePassword = template.keyStorePassword();
        this.keyStoreCertificatePassword = template.keyStoreCertificatePassword();
        this.keyAlias = template.keyAlias();
        this.sslContext = template.sslContext();
        this.trustStoreFileName = template.trustStoreFileName();
        this.trustStoreType = template.trustStoreType();
        this.trustStorePassword = template.trustStorePassword();
        this.sniHostName = template.sniHostName();
        this.protocol = template.protocol();
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        this.enabled(typed.getBooleanProperty("infinispan.client.hotrod.use_ssl", this.enabled, true));
        this.keyStoreFileName(typed.getProperty("infinispan.client.hotrod.key_store_file_name", this.keyStoreFileName, true));
        if (typed.containsKey("infinispan.client.hotrod.key_store_type")) {
            this.keyStoreType(typed.getProperty("infinispan.client.hotrod.key_store_type", null, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.key_store_password")) {
            this.keyStorePassword(typed.getProperty("infinispan.client.hotrod.key_store_password", null, true).toCharArray());
        }
        if (typed.containsKey("infinispan.client.hotrod.key_store_certificate_password")) {
            this.keyStoreCertificatePassword(typed.getProperty("infinispan.client.hotrod.key_store_certificate_password", null, true).toCharArray());
        }
        if (typed.containsKey("infinispan.client.hotrod.key_alias")) {
            this.keyAlias(typed.getProperty("infinispan.client.hotrod.key_alias", null, true));
        }
        this.trustStoreFileName(typed.getProperty("infinispan.client.hotrod.trust_store_file_name", this.trustStoreFileName, true));
        if (typed.containsKey("infinispan.client.hotrod.trust_store_type")) {
            this.trustStoreType(typed.getProperty("infinispan.client.hotrod.trust_store_type", null, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.trust_store_password")) {
            this.trustStorePassword(typed.getProperty("infinispan.client.hotrod.trust_store_password", null, true).toCharArray());
        }
        if (typed.containsKey("infinispan.client.hotrod.ssl_protocol")) {
            this.protocol(typed.getProperty("infinispan.client.hotrod.ssl_protocol", null, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.sni_host_name")) {
            this.sniHostName(typed.getProperty("infinispan.client.hotrod.sni_host_name", null, true));
        }
        this.sslContext((SSLContext)typed.get("infinispan.client.hotrod.ssl_context"));
        return this.builder.getBuilder();
    }
}

