/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;

public final class QueryOperation
extends RetryOnFailureOperation<QueryResponse> {
    private final RemoteQuery remoteQuery;

    public QueryOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, int flags, ClientIntelligence clientIntelligence, RemoteQuery remoteQuery) {
        super(codec, transportFactory, cacheName, topologyId, flags, clientIntelligence);
        this.remoteQuery = remoteQuery;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    @Override
    protected QueryResponse executeOperation(Transport transport) {
        QueryResponse queryResponse;
        byte[] requestBytes;
        HeaderParams params = this.writeHeader(transport, (short)31);
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setQueryString(this.remoteQuery.getQueryString());
        if (this.remoteQuery.getStartOffset() > 0L) {
            queryRequest.setStartOffset(Long.valueOf(this.remoteQuery.getStartOffset()));
        }
        if (this.remoteQuery.getMaxResults() >= 0) {
            queryRequest.setMaxResults(Integer.valueOf(this.remoteQuery.getMaxResults()));
        }
        queryRequest.setNamedParameters(this.getNamedParameters());
        SerializationContext serCtx = this.remoteQuery.getSerializationContext();
        Marshaller marshaller = null;
        if (serCtx != null) {
            try {
                requestBytes = ProtobufUtil.toByteArray((ImmutableSerializationContext)serCtx, (Object)queryRequest);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
        }
        marshaller = this.remoteQuery.getCache().getRemoteCacheManager().getMarshaller();
        try {
            requestBytes = marshaller.objectToByteBuffer((Object)queryRequest);
        }
        catch (IOException e) {
            throw new HotRodClientException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        transport.writeArray(requestBytes);
        transport.flush();
        this.readHeaderAndValidate(transport, params);
        byte[] responseBytes = transport.readArray();
        if (serCtx != null) {
            try {
                queryResponse = (QueryResponse)ProtobufUtil.fromByteArray((ImmutableSerializationContext)serCtx, (byte[])responseBytes, QueryResponse.class);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
        }
        try {
            queryResponse = (QueryResponse)marshaller.objectFromByteBuffer(responseBytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new HotRodClientException(e);
        }
        return queryResponse;
    }

    private List<QueryRequest.NamedParameter> getNamedParameters() {
        Map namedParameters = this.remoteQuery.getParameters();
        if (namedParameters == null || namedParameters.isEmpty()) {
            return null;
        }
        SerializationContext serCtx = this.remoteQuery.getSerializationContext();
        ArrayList<QueryRequest.NamedParameter> params = new ArrayList<QueryRequest.NamedParameter>(namedParameters.size());
        for (Map.Entry e : namedParameters.entrySet()) {
            Object value = e.getValue();
            if (serCtx != null) {
                if (value instanceof Enum) {
                    EnumMarshaller encoder = (EnumMarshaller)serCtx.getMarshaller(value.getClass());
                    value = encoder.encode((Enum)value);
                } else if (value instanceof Boolean) {
                    value = value.toString();
                } else if (value instanceof Date) {
                    value = ((Date)value).getTime();
                } else if (value instanceof Instant) {
                    value = ((Instant)value).toEpochMilli();
                }
            }
            params.add(new QueryRequest.NamedParameter((String)e.getKey(), value));
        }
        return params;
    }
}

