/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Set;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class TxPutFromLoadInterceptor
extends BaseRpcInterceptor {
    private static final Log log = LogFactory.getLog(TxPutFromLoadInterceptor.class);
    private PutFromLoadValidator putFromLoadValidator;
    private final String cacheName;
    private RpcManager rpcManager;
    private CacheCommandInitializer cacheCommandInitializer;
    private DataContainer dataContainer;

    public TxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, String cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    @Inject
    public void injectDependencies(RpcManager rpcManager, CacheCommandInitializer cacheCommandInitializer, DataContainer dataContainer) {
        this.rpcManager = rpcManager;
        this.cacheCommandInitializer = cacheCommandInitializer;
        this.dataContainer = dataContainer;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            for (WriteCommand wc : command.getModifications()) {
                if (wc instanceof InvalidateCommand) {
                    for (Object key : ((InvalidateCommand)wc).getKeys()) {
                        this.dataContainer.remove(key);
                    }
                    continue;
                }
                for (Object key : wc.getAffectedKeys()) {
                    this.dataContainer.remove(key);
                }
            }
        } else {
            for (WriteCommand wc : command.getModifications()) {
                if (wc instanceof InvalidateCommand) {
                    for (Object key : ((InvalidateCommand)wc).getKeys()) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Invalidating key %s with lock owner %s", key, ctx.getLockOwner());
                        }
                        this.putFromLoadValidator.beginInvalidatingKey(ctx.getLockOwner(), key);
                    }
                    continue;
                }
                Set keys = wc.getAffectedKeys();
                if (log.isTraceEnabled()) {
                    log.tracef("Invalidating keys %s with lock owner %s", (Object)keys, ctx.getLockOwner());
                }
                for (Object key : keys) {
                    this.putFromLoadValidator.beginInvalidatingKey(ctx.getLockOwner(), key);
                }
            }
        }
        return this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
    }

    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Commit command received, end invalidation", new Object[0]);
        }
        return this.endInvalidationAndInvokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Rollback command received, end invalidation", new Object[0]);
        }
        return this.endInvalidationAndInvokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object endInvalidationAndInvokeNextInterceptor(TxInvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            if (ctx.isOriginLocal()) {
                Set affectedKeys = ctx.getAffectedKeys();
                if (log.isTraceEnabled()) {
                    log.tracef("Sending end invalidation for keys %s asynchronously", (Object)affectedKeys);
                }
                if (!affectedKeys.isEmpty()) {
                    EndInvalidationCommand commitCommand = this.cacheCommandInitializer.buildEndInvalidationCommand(this.cacheName, affectedKeys.toArray(), ctx.getGlobalTransaction());
                    this.rpcManager.invokeRemotely(null, (ReplicableCommand)commitCommand, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
                }
            }
        }
        finally {
            return this.invokeNextInterceptor((InvocationContext)ctx, command);
        }
    }
}

