/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.collection;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

class CollectionAccess
implements CollectionRegionAccessStrategy {
    private final CollectionRegionImpl region;
    private final AccessDelegate delegate;

    CollectionAccess(CollectionRegionImpl region, AccessDelegate delegate) {
        this.region = region;
        this.delegate = delegate;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(session, key, txTimestamp);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
        this.delegate.remove(session, key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem(session, key);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createCollectionKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getCollectionId(cacheKey);
    }
}

