/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonElementType;

public class UnexpectedJsonElementTypeException
extends Exception {
    private final JsonAccessor accessor;
    private final List<JsonElementType<?>> expectedTypes;
    private final JsonElement actualElement;

    public UnexpectedJsonElementTypeException(JsonAccessor accessor, JsonElementType<?> expectedType, JsonElement actualElement) {
        this(accessor, Arrays.asList(expectedType), actualElement);
    }

    public UnexpectedJsonElementTypeException(JsonAccessor accessor, List<? extends JsonElementType<?>> expectedTypes, JsonElement actualElement) {
        this.accessor = accessor;
        this.expectedTypes = Collections.unmodifiableList(new ArrayList(expectedTypes));
        this.actualElement = actualElement;
    }

    @Override
    public String getMessage() {
        return "Unexpected type at '" + this.accessor + "'. Expected one of " + this.expectedTypes + ", got '" + this.actualElement + "'";
    }

    public JsonAccessor getAccessor() {
        return this.accessor;
    }

    public List<JsonElementType<?>> getExpectedTypes() {
        return this.expectedTypes;
    }

    public JsonElement getActualElement() {
        return this.actualElement;
    }
}

