/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchSchemaMigrator
implements ElasticsearchSchemaMigrator {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public DefaultElasticsearchSchemaMigrator(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public void migrate(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        String indexName = indexMetadata.getName();
        IndexSettings settings = indexMetadata.getSettings();
        try {
            if (!settings.isEmpty() && !this.schemaValidator.isSettingsValid(indexMetadata, executionOptions)) {
                this.schemaAccessor.closeIndex(indexName);
                try {
                    this.schemaAccessor.updateSettings(indexName, settings);
                }
                catch (RuntimeException mainException) {
                    try {
                        this.schemaAccessor.openIndex(indexName);
                    }
                    catch (RuntimeException e) {
                        mainException.addSuppressed(e);
                    }
                    throw mainException;
                }
                this.schemaAccessor.openIndex(indexName);
            }
            for (Map.Entry<String, TypeMapping> entry : indexMetadata.getMappings().entrySet()) {
                String mappingName = entry.getKey();
                TypeMapping mapping = entry.getValue();
                this.schemaAccessor.putMapping(indexName, mappingName, mapping);
            }
        }
        catch (SearchException e) {
            throw LOG.schemaUpdateFailed(indexName, (Exception)((Object)e));
        }
    }
}

