/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleBulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteWorkBuilder;

public class DeleteWork
extends SimpleBulkableElasticsearchWork<Void> {
    private static final ElasticsearchRequestSuccessAssessor SUCCESS_ASSESSOR = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();

    public DeleteWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    public static class Builder
    extends SimpleBulkableElasticsearchWork.Builder<Builder>
    implements DeleteWorkBuilder {
        private final String indexName;
        private final String typeName;
        private final String id;

        public Builder(String indexName, String typeName, String id) {
            super(indexName, SUCCESS_ASSESSOR);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(this.id);
            return builder.build();
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            return JsonBuilder.object().add("delete", JsonBuilder.object().addProperty("_index", this.indexName).addProperty("_type", this.typeName).addProperty("_id", this.id)).build();
        }

        @Override
        public DeleteWork build() {
            return new DeleteWork(this);
        }
    }
}

