/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.exception.AssertionFailure;

public abstract class SimpleBulkableElasticsearchWork<R>
extends SimpleElasticsearchWork<R>
implements BulkableElasticsearchWork<R> {
    private final JsonObject bulkableActionMetadata;

    protected SimpleBulkableElasticsearchWork(Builder<?> builder) {
        super(builder);
        this.bulkableActionMetadata = builder.buildBulkableActionMetadata();
    }

    @Override
    public void aggregate(ElasticsearchWorkAggregator aggregator) {
        aggregator.addBulkable(this);
    }

    @Override
    public JsonObject getBulkableActionMetadata() {
        return this.bulkableActionMetadata;
    }

    @Override
    public JsonObject getBulkableActionBody() {
        List<JsonObject> bodyParts = this.request.getBodyParts();
        if (!bodyParts.isEmpty()) {
            if (bodyParts.size() > 1) {
                throw new AssertionFailure("Found a bulkable action with multiple body parts: " + bodyParts);
            }
            return bodyParts.get(0);
        }
        return null;
    }

    @Override
    public boolean handleBulkResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        if (this.resultAssessor.isSuccess(context, bulkResponseItem)) {
            this.afterSuccess(context);
            if (this.markIndexDirty) {
                context.setIndexDirty(this.dirtiedIndexName);
            }
            return true;
        }
        return false;
    }

    protected static abstract class Builder<B>
    extends SimpleElasticsearchWork.Builder<B> {
        public Builder(String dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            super(dirtiedIndexName, resultAssessor);
        }

        protected abstract JsonObject buildBulkableActionMetadata();
    }
}

