/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.security.PrivilegedActionException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.BulkGetKeysResponse;
import org.infinispan.server.hotrod.BulkGetResponse;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ClientListenerRequestContext;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.ExecRequestContext;
import org.infinispan.server.hotrod.ExecResponse;
import org.infinispan.server.hotrod.GetAllResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.IterationNextResponse;
import org.infinispan.server.hotrod.IterationStartRequest;
import org.infinispan.server.hotrod.IterationStartResponse;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.QueryResponse;
import org.infinispan.server.hotrod.ResponseWriting;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.server.hotrod.SizeResponse;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.util.BulkUtil;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;
import org.infinispan.util.KeyValuePair;

public class ContextHandler
extends SimpleChannelInboundHandler<CacheDecodeContext> {
    private static final Log log = (Log)LogFactory.getLog(ContextHandler.class, Log.class);
    private final HotRodServer server;
    private final NettyTransport transport;
    private final Executor executor;
    private final TaskManager taskManager;

    public ContextHandler(HotRodServer server, NettyTransport transport, Executor executor) {
        this.server = server;
        this.transport = transport;
        this.executor = executor;
        this.taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(server.getCacheManager()).getComponent(TaskManager.class);
    }

    protected void channelRead0(ChannelHandlerContext ctx, CacheDecodeContext msg) throws Exception {
        this.executor.execute(() -> {
            try {
                this.realRead(ctx, msg);
            }
            catch (PrivilegedActionException e) {
                ctx.fireExceptionCaught(e.getCause());
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRead(ChannelHandlerContext ctx, CacheDecodeContext msg) throws Exception {
        HotRodHeader h = msg.header;
        switch (h.op) {
            case PUT: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.put());
                break;
            }
            case PUT_IF_ABSENT: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.putIfAbsent());
                break;
            }
            case REPLACE: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.replace());
                break;
            }
            case REPLACE_IF_UNMODIFIED: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.replaceIfUnmodified());
                break;
            }
            case CONTAINS_KEY: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.containsKey());
                break;
            }
            case GET: 
            case GET_WITH_VERSION: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.get());
                break;
            }
            case GET_STREAM: 
            case GET_WITH_METADATA: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.getKeyMetadata());
                break;
            }
            case REMOVE: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.remove());
                break;
            }
            case REMOVE_IF_UNMODIFIED: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.removeIfUnmodified());
                break;
            }
            case PING: {
                ResponseWriting.writeResponse(msg, ctx.channel(), new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.PING, OperationStatus.Success, h.topologyId));
                break;
            }
            case STATS: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder.createStatsResponse(msg, this.transport));
                break;
            }
            case CLEAR: {
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.clear());
                break;
            }
            case SIZE: {
                ResponseWriting.writeResponse(msg, ctx.channel(), new SizeResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, msg.cache.size()));
                break;
            }
            case EXEC: {
                ExecRequestContext execContext = (ExecRequestContext)msg.operationDecodeContext;
                Object marshaller = this.server.getMarshaller() != null ? this.server.getMarshaller() : new GenericJBossMarshaller();
                TaskContext taskContext = new TaskContext().marshaller(marshaller).cache(msg.cache).parameters(execContext.getParams()).subject(msg.subject);
                byte[] result = (byte[])this.taskManager.runTask(execContext.getName(), taskContext).get();
                ResponseWriting.writeResponse(msg, ctx.channel(), new ExecResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, result == null ? new byte[]{} : result));
                break;
            }
            case BULK_GET: {
                int size = (Integer)msg.operationDecodeContext;
                if (CacheDecodeContext.isTrace) {
                    log.tracef("About to create bulk response count = %d", size);
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), new BulkGetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, size, (CacheSet<Map.Entry<byte[], byte[]>>)msg.cache.entrySet()));
                break;
            }
            case BULK_GET_KEYS: {
                int scope = (Integer)msg.operationDecodeContext;
                if (CacheDecodeContext.isTrace) {
                    log.tracef("About to create bulk get keys response scope = %d", scope);
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), new BulkGetKeysResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, scope, BulkUtil.getAllKeys(msg.cache, scope)));
                break;
            }
            case QUERY: {
                byte[] queryResult = this.server.query(msg.cache, (byte[])msg.operationDecodeContext);
                ResponseWriting.writeResponse(msg, ctx.channel(), new QueryResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, queryResult));
                break;
            }
            case ADD_CLIENT_LISTENER: {
                ClientListenerRequestContext clientContext = (ClientListenerRequestContext)msg.operationDecodeContext;
                this.server.getClientListenerRegistry().addClientListener(msg.decoder, ctx.channel(), h, clientContext.getListenerId(), msg.cache, clientContext.isIncludeCurrentState(), (KeyValuePair<Optional<KeyValuePair<String, List<byte[]>>>, Optional<KeyValuePair<String, List<byte[]>>>>)new KeyValuePair(clientContext.getFilterFactoryInfo(), clientContext.getConverterFactoryInfo()), clientContext.isUseRawData(), clientContext.getListenerInterests());
                break;
            }
            case REMOVE_CLIENT_LISTENER: {
                byte[] listenerId = (byte[])msg.operationDecodeContext;
                if (this.server.getClientListenerRegistry().removeClientListener(listenerId, (Cache)msg.cache)) {
                    ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder.createSuccessResponse(h, null));
                    break;
                }
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder.createNotExecutedResponse(h, null));
                break;
            }
            case ITERATION_START: {
                IterationStartRequest iterationStart = (IterationStartRequest)msg.operationDecodeContext;
                Optional<BitSet> optionBitSet = iterationStart.getOptionBitSet().isPresent() ? Optional.of(BitSet.valueOf(iterationStart.getOptionBitSet().get())) : Optional.empty();
                String iterationId = this.server.getIterationManager().start(msg.cache.getName(), optionBitSet, iterationStart.getFactory(), iterationStart.getBatch(), iterationStart.isMetadata());
                ResponseWriting.writeResponse(msg, ctx.channel(), new IterationStartResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, iterationId));
                break;
            }
            case ITERATION_NEXT: {
                String iterationId = (String)msg.operationDecodeContext;
                IterableIterationResult iterationResult = this.server.getIterationManager().next(msg.cache.getName(), iterationId);
                ResponseWriting.writeResponse(msg, ctx.channel(), new IterationNextResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, iterationResult));
                break;
            }
            case ITERATION_END: {
                String iterationId = (String)msg.operationDecodeContext;
                boolean removed = this.server.getIterationManager().close(msg.cache.getName(), iterationId);
                ResponseWriting.writeResponse(msg, ctx.channel(), new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.ITERATION_END, removed ? OperationStatus.Success : OperationStatus.InvalidIteration, h.topologyId));
                break;
            }
            case PUT_ALL: {
                msg.cache.putAll((Map)msg.operationDecodeContext, msg.buildMetadata());
                ResponseWriting.writeResponse(msg, ctx.channel(), msg.decoder.createSuccessResponse(h, null));
                break;
            }
            case GET_ALL: {
                Map map = msg.cache.getAll((Set)msg.operationDecodeContext);
                ResponseWriting.writeResponse(msg, ctx.channel(), new GetAllResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, map));
                break;
            }
            case PUT_STREAM: {
                ByteBuf buf = (ByteBuf)msg.operationDecodeContext;
                try {
                    byte[] bytes = new byte[buf.readableBytes()];
                    buf.readBytes(bytes);
                    msg.operationDecodeContext = bytes;
                    long version = msg.params.streamVersion;
                    if (version == 0L) {
                        ResponseWriting.writeResponse(msg, ctx.channel(), msg.put());
                        break;
                    }
                    if (version < 0L) {
                        ResponseWriting.writeResponse(msg, ctx.channel(), msg.putIfAbsent());
                        break;
                    }
                    ResponseWriting.writeResponse(msg, ctx.channel(), msg.replaceIfUnmodified());
                    break;
                }
                finally {
                    buf.release();
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation invoked: " + (Object)((Object)msg.header.op));
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        log.tracef("Channel %s became active", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        log.tracef("Channel %s writability changed", ctx.channel());
        this.server.getClientListenerRegistry().findAndWriteEvents(ctx.channel());
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg.getClass() == CacheDecodeContext.class;
    }
}

